import Mock from 'mockjs';
import MockUtil from './util';
import {
  mockEntities, createEntity, updateEntity, deleteEntity,
} from './data/entities';
import mockEnumValues from './data/enumValues';
import { FIELD_TYPE } from './data/consts';
import mockFetchEnumValues from './fetchEnumOptions';
import setting from '../src/setting';

const entity = {};
const enumValues = mockEnumValues(setting);
const entities = mockEntities(setting, enumValues);
mockFetchEnumValues(enumValues);

entity[setting.entityId] = {
  api: setting.api,
};
setting.fields.filter(field => field.type === FIELD_TYPE.RELATIONSHIP.code)
  .forEach(({ code, relationshipEntity }) => {
    entity[relationshipEntity.id] = {
      api: relationshipEntity.api,
    };
    entity[setting.entityId].relationship = {
      ...entity[setting.entityId].relationship,
      [code]: {
        relationshipEntityId: relationshipEntity.id,
        relationshipEntityCode: relationshipEntity.code,
      },
    };
  });
setting.subEntities.forEach((subEntity) => {
  entity[subEntity.id] = {
    api: subEntity.api,
  };
  subEntity.fields.filter(field => field.type === FIELD_TYPE.RELATIONSHIP.code)
    .forEach(({ code, relationshipEntity }) => {
      entity[relationshipEntity.id] = {
        api: relationshipEntity.api,
      };
      entity[subEntity.id].relationship = {
        ...entity[subEntity.id].relationship,
        [code]: {
          relationshipEntityId: relationshipEntity.id,
          relationshipEntityCode: relationshipEntity.code,
        },
      };
    });
});

Object.keys(entity).forEach((entityId) => {
  const urls = Object.values(entity[entityId].api)
    .reduce((result, item) => (result[item.url] ? {
      ...result,
      [item.url]: [...result[item.url], item.method],
    } : {
      ...result,
      [item.url]: [item.method],
    }), {});

  Object.keys(urls).forEach((url) => {
    const urlRegExp = new RegExp((`${url}([?#].*)?$`).replace(/{.+}/g, '.+'));
    Mock.mock(urlRegExp, (options) => {
      const type = options.type;
      const params = MockUtil.getRequestParams(options);
      MockUtil.log(options);
      switch (type) {
        case 'GET': {
          const rows = entities[entityId]
            .filter((row, index) => MockUtil.filter(row, index, params, entity[entityId].relationship))
            .map(row => MockUtil.getFields(row, params, entities, entity[entityId].relationship))
            .sort((prevRow, nextRow) => MockUtil.sort(prevRow, nextRow, params));
          return {
            code: 1,
            message: 'success',
            result: {
              rows,
              summary: {
                total: rows.length,
              },
            },
          };
        }
        case 'PUT': {
          updateEntity(entityId, params);
          return {
            code: 1,
            message: 'success',
          };
        }
        case 'POST': {
          createEntity(entityId, params);
          return {
            code: 1,
            message: 'success',
          };
        }
        case 'DELETE': {
          if (!params.isAllSelected) {
            params.includes.forEach(id => deleteEntity(entityId, id));
          }
          return {
            code: 1,
            message: 'success',
          };
        }
      }
    });
  });
});

Mock.setup({
  timeout: 1000,
});

export default Mock;
