import { SEARCH_OPERATION } from './data/consts';
import MockComponent from './MockComponent';

export default {
  log(options, isString) {
    // eslint-disable-next-line no-console
    console.log(
      options.url,
      isString ? JSON.stringify(this.getRequestParams(options), null, 4) : this.getRequestParams(options),
    );
  },

  consoleRequestParams(url, options) {
    const params = this.getRequestParams(options);
    // eslint-disable-next-line no-console
    console.log(`${url} requestParams:\r\n${JSON.stringify(params, null, 4)}`);
  },

  getRequestParams(options) {
    const type = options.type;
    const url = options.url;
    const body = options.body;
    let params = {};

    switch (type) {
      case 'POST':
      case 'PUT':
      case 'DELETE':
        try {
          params = JSON.parse(body);
        } catch (e) {
          params = body;
        }
        break;
      case 'GET':
        if (url.indexOf('?') >= 0) {
          const query = url.substr(url.indexOf('?') + 1);
          const lets = query.split('&');
          for (let i = 0; i < lets.length; i++) {
            const pair = lets[i].split('=');
            // If first entry with this name
            if (typeof params[pair[0]] === 'undefined') {
              params[pair[0]] = decodeURIComponent(pair[1]);
              // If second entry with this name
            } else if (typeof params[pair[0]] === 'string') {
              const arr = [params[pair[0]], decodeURIComponent(pair[1])];
              params[pair[0]] = arr;
            } else {
              params[pair[0]].push(decodeURIComponent(pair[1]));
            }
          }
        }
        if (body) {
          params = {
            ...params,
            ...JSON.parse(body),
          };
        }
    }

    return params;
  },

  filter(row, index, queryConditions, relationship) {
    const {
      pageNo, pageSize, conditions,
    } = queryConditions;

    let result = index >= (pageNo - 1) * pageSize && index < pageNo * pageSize;

    const { fields, entities } = conditions;

    let cal = true,
      fromNum,
      toNum;

    result = result && fields.every((field) => {
      const { code, operation, value } = field;
      switch (operation) {
        case SEARCH_OPERATION.EQUAL.code:
          return String(row[code]) === String(value[0]);
        case SEARCH_OPERATION.LIKE.code:
          return String(row[code]).indexOf(String(value[0])) > -1;
        case SEARCH_OPERATION.IN.code:
          return value.indexOf(String(row[code])) > -1;
        case SEARCH_OPERATION.RANGE.code:
          cal = true;
          fromNum = value[0];
          toNum = value[1];
          if (!isNumber(row[code])) {
            return false;
          }
          if (isNumber(fromNum)) {
            cal = cal && Number(row[code]) >= fromNum;
          }
          if (isNumber(toNum)) {
            cal = cal && Number(row[code]) <= toNum;
          }
          return cal;
        case SEARCH_OPERATION.LARGER_THEN.code:
          cal = true;
          fromNum = value[0];
          if (!isNumber(row[code])) {
            return false;
          }
          if (isNumber(fromNum)) {
            cal = cal && Number(row[code]) >= fromNum;
          }
          return cal;
        case SEARCH_OPERATION.LITTLE_THEN.code:
          cal = true;
          toNum = value[0];
          if (!isNumber(row[code])) {
            return false;
          }
          if (isNumber(toNum)) {
            cal = cal && Number(row[code]) <= toNum;
          }
          return cal;
      }
    });

    return result;
  },

  sort(prevRow, nextRow, queryConditions) {
    const { sort } = queryConditions;
    if (Array.isArray(sort) && sort.length) {
      const { field, order } = sort[0];
      if (order === 'ascend') {
        return prevRow[field] > nextRow[field] ? 1 : -1;
      } if (order === 'descend') {
        return prevRow[field] > nextRow[field] ? -1 : 1;
      }
      return 0;
    }
    return 0;
  },

  getFields(row, queryConditions, entities, relationship) {
    let returnRow = { ...row };

    Object.keys(row).forEach((code) => {
      if (relationship && relationship[code]) {
        const { relationshipEntityId, relationshipEntityCode } = relationship[code];

        const entity = queryConditions.entity.entities.find(entity => entity.code === relationshipEntityCode);
        if (entity) {
          const relationshipRow = entities[relationshipEntityId].find(item => item.id === row[code]);
          if (relationshipRow) {
            const mergeRow = entity.fields.reduce((result, fieldCode) => ({
              ...result,
              [`${entity.code}.${fieldCode}`]: relationshipRow[fieldCode],
            }), {});
            returnRow = {
              ...returnRow,
              ...mergeRow,
            };
          }
        }
      }
    });
    return returnRow;
  },

  replaceComponent(setting) {
    setting.buttons = setting.buttons.map((button) => {
      if (button.component) {
        return {
          ...button,
          component: MockComponent,
        };
      }
      return button;
    });

    function setFieldComponent(field) {
      let _field = field;
      if (field.columnAttribute && field.columnAttribute.component) {
        _field = {
          ..._field,
          columnAttribute: {
            ...field.columnAttribute,
            component: MockComponent,
          },
        };
      }
      if (field.editAttribute && field.editAttribute.component) {
        _field = {
          ..._field,
          editAttribute: {
            ...field.editAttribute,
            component: MockComponent,
          },
        };
      }
      if (field.searchAttribute && field.searchAttribute.component) {
        _field = {
          ..._field,
          searchAttribute: {
            ...field.searchAttribute,
            component: MockComponent,
          },
        };
      }
      return _field;
    }

    setting.fields = setting.fields.map((field) => {
      let _field = setFieldComponent(field);
      if (field.relationshipEntity && field.relationshipEntity.fields) {
        _field = {
          ..._field,
          relationshipEntity: {
            ...field.relationshipEntity,
            fields: field.relationshipEntity.fields.map(field => setFieldComponent(field)),
          },
        };
      }
      return _field;
    });

    setting.subEntities = setting.subEntities.map(entity => ({
      ...entity,
      fields: entity.fields.map((field) => {
        let _field = setFieldComponent(field);
        if (field.relationshipEntity && field.relationshipEntity.fields) {
          _field = {
            ..._field,
            relationshipEntity: {
              ...field.relationshipEntity,
              fields: field.relationshipEntity.fields.map(field => setFieldComponent(field)),
            },
          };
        }
        return _field;
      }),
    }));
    return setting;
  },
};


function isNumber(val) {
  if (parseFloat(val).toString() === 'NaN') {
    return false;
  }
  return true;
}
