export default {
  projectId: '0',
  appId: '1',
  moduleId: '11',
  entityId: '113',
  buttons: [{
    id: 0, name: '新增', layout: 'top', enable: true, action: 'create',
  }, {
    id: 1, name: '修改', layout: 'table', enable: true, action: 'update',
  }, {
    id: 2, name: '删除', layout: 'table', enable: true, action: 'delete',
  }, {
    id: 3, name: '删除', layout: 'bottom', enable: true, action: 'delete',
  }, {
    id: 4, name: '导入', layout: 'top', enable: false, action: 'import',
  }, {
    id: 5, name: '导出', layout: 'top', enable: false, action: 'export',
  }, {
    id: 6, name: '打印', layout: 'top', enable: false, action: 'print',
  }],
  table: { selectable: true, selectAllEnable: false },
  api: {
    query: { url: '/departments', method: 'get' }, create: { url: '/department', method: 'post' }, update: { url: '/department/{id}', method: 'put' }, delete: { url: '/departments', method: 'delete' },
  },
  fields: [{
    code: 'id',
    name: 'ID',
    type: 'string',
    maxLength: 20,
    editable: false,
    searchable: true,
    required: true,
    discribeType: '0',
    originEditable: false,
    originSearchable: true,
    visibleInTable: false,
    visibleInDetail: false,
    attribute: { displayName: 'ID' },
    columnAttribute: {},
    editAttribute: {},
    searchAttribute: {
      displayName: 'ID', operation: 'eq', uiWidget: 'input', required: false, isPermanent: false,
    },
  }, {
    code: 'code',
    name: '部门代码',
    type: 'string',
    maxLength: 20,
    editable: true,
    searchable: true,
    required: true,
    discribeType: '0',
    originEditable: true,
    originSearchable: true,
    visibleInTable: true,
    visibleInDetail: true,
    attribute: { displayName: '部门代码' },
    columnAttribute: { align: 'left', sortable: true, width: 200 },
    editAttribute: {
      uiWidget: 'input', required: true, editableWhenCreate: true, editableWhenUpdate: true,
    },
    searchAttribute: {
      displayName: '部门代码', operation: 'eq', uiWidget: 'input', required: false, isPermanent: false,
    },
  }, {
    code: 'name',
    name: '部门名称',
    type: 'string',
    maxLength: 100,
    editable: true,
    searchable: true,
    required: true,
    discribeType: '1',
    originEditable: true,
    originSearchable: true,
    visibleInTable: true,
    visibleInDetail: true,
    attribute: { displayName: '部门名称' },
    columnAttribute: { align: 'left', sortable: true, width: null },
    editAttribute: {
      uiWidget: 'input', required: true, editableWhenCreate: true, editableWhenUpdate: true,
    },
    searchAttribute: {
      displayName: '部门名称', operation: 'eq', uiWidget: 'input', required: false, isPermanent: false,
    },
  }, {
    code: 'leader',
    name: '部门主管',
    type: 'string',
    maxLength: 100,
    editable: true,
    searchable: true,
    required: true,
    discribeType: '0',
    originEditable: true,
    originSearchable: true,
    visibleInTable: true,
    visibleInDetail: true,
    attribute: { displayName: '部门主管' },
    columnAttribute: { align: 'left', sortable: true, width: null },
    editAttribute: {
      uiWidget: 'input', required: true, editableWhenCreate: true, editableWhenUpdate: true,
    },
    searchAttribute: {
      displayName: '部门主管', operation: 'eq', uiWidget: 'input', required: false, isPermanent: false,
    },
  }, {
    code: 'companyId',
    name: '公司',
    type: 'relationship',
    maxLength: 20,
    editable: true,
    searchable: true,
    required: true,
    discribeType: '0',
    relationshipEntity: {
      id: '110',
      moduleId: '11',
      code: 'Company',
      name: '公司',
      desc: '公司',
      api: {
        query: { url: '/companyList', method: 'get' }, create: { url: '/company', method: 'post' }, update: { url: '/company/{id}', method: 'put' }, delete: { url: '/companyList', method: 'delete' },
      },
      subEntities: [{ id: '111' }, { id: '113' }],
      fields: [{
        code: 'id', name: 'ID', type: 'string', maxLength: 20, searchable: false, discribeType: '0', visibleInTable: false, originSearchable: true, attribute: { displayName: 'ID' }, columnAttribute: {}, searchAttribute: {},
      }, {
        code: 'code', name: '公司代码', type: 'string', maxLength: 20, searchable: false, discribeType: '0', visibleInTable: false, originSearchable: true, attribute: { displayName: '公司代码' }, columnAttribute: {}, searchAttribute: {},
      }, {
        code: 'name',
        name: '公司名称',
        type: 'string',
        maxLength: 100,
        searchable: true,
        discribeType: '1',
        visibleInTable: true,
        originSearchable: true,
        attribute: { displayName: '公司名称' },
        columnAttribute: { align: 'left', sortable: true, width: null },
        searchAttribute: {
          displayName: '公司名称', operation: 'eq', uiWidget: 'input', required: false, isPermanent: false,
        },
      }, {
        code: 'taxNo', name: '税号', type: 'string', maxLength: 50, searchable: false, discribeType: '2', visibleInTable: false, originSearchable: true, attribute: { displayName: '税号' }, columnAttribute: {}, searchAttribute: {},
      }, {
        code: 'address', name: '地址', type: 'string', maxLength: 200, searchable: false, discribeType: '2', visibleInTable: false, originSearchable: false, attribute: { displayName: '地址' }, columnAttribute: {}, searchAttribute: {},
      }, {
        code: 'createTime', name: '创建时间', type: 'timestamp', searchable: false, discribeType: '0', visibleInTable: false, originSearchable: false, attribute: { displayName: '创建时间', timeFormatter: 'yyyy-MM-dd hh:mm:ss' }, columnAttribute: {}, searchAttribute: {},
      }, {
        code: 'createPerson', name: '创建人', type: 'string', searchable: false, discribeType: '0', visibleInTable: false, originSearchable: false, attribute: { displayName: '创建人' }, columnAttribute: {}, searchAttribute: {},
      }, {
        code: 'updateTime', name: '修改时间', type: 'timestamp', searchable: false, discribeType: '0', visibleInTable: false, originSearchable: false, attribute: { displayName: '修改时间', timeFormatter: 'yyyy-MM-dd hh:mm:ss' }, columnAttribute: {}, searchAttribute: {},
      }, {
        code: 'updatePerson', name: '修改人', type: 'string', searchable: false, discribeType: '0', visibleInTable: false, originSearchable: false, attribute: { displayName: '修改人' }, columnAttribute: {}, searchAttribute: {},
      }],
      relationshipFields: [],
    },
    originEditable: true,
    originSearchable: true,
    visibleInTable: false,
    visibleInDetail: true,
    attribute: { displayName: '公司' },
    columnAttribute: {},
    editAttribute: {
      uiWidget: 'select', required: true, editableWhenCreate: true, editableWhenUpdate: true,
    },
    searchAttribute: {
      displayName: '公司', operation: 'eq', uiWidget: 'select', required: false, isPermanent: false,
    },
  }, {
    code: 'createTime', name: '创建时间', type: 'timestamp', editable: false, searchable: false, required: true, discribeType: '0', originEditable: false, originSearchable: false, visibleInTable: false, visibleInDetail: false, attribute: { displayName: '创建时间', timeFormatter: 'yyyy-MM-dd hh:mm:ss' }, columnAttribute: {}, editAttribute: {}, searchAttribute: {},
  }, {
    code: 'createPerson', name: '创建人', type: 'string', editable: false, searchable: false, required: true, discribeType: '0', originEditable: false, originSearchable: false, visibleInTable: false, visibleInDetail: false, attribute: { displayName: '创建人' }, columnAttribute: {}, editAttribute: {}, searchAttribute: {},
  }, {
    code: 'updateTime', name: '修改时间', type: 'timestamp', editable: false, searchable: false, required: true, discribeType: '0', originEditable: false, originSearchable: false, visibleInTable: false, visibleInDetail: false, attribute: { displayName: '修改时间', timeFormatter: 'yyyy-MM-dd hh:mm:ss' }, columnAttribute: {}, editAttribute: {}, searchAttribute: {},
  }, {
    code: 'updatePerson', name: '修改人', type: 'string', editable: false, searchable: false, required: true, discribeType: '0', originEditable: false, originSearchable: false, visibleInTable: false, visibleInDetail: false, attribute: { displayName: '修改人' }, columnAttribute: {}, editAttribute: {}, searchAttribute: {},
  }],
  subEntities: [],
  authAppId: '1',
};
