/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.gen.engine;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.FileType;
import com.xforceplus.ultraman.bocp.gen.config.BocpConfigBuilder;
import com.xforceplus.ultraman.bocp.gen.config.BocpTemplateConfig;
import com.xforceplus.ultraman.bocp.gen.po.BoGenInfo;
import java.beans.Introspector;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoVelocityTemplateEngine {
    protected static final Logger logger = LoggerFactory.getLogger(BoVelocityTemplateEngine.class);
    private static final String DOT_VM = ".vm";
    private VelocityEngine velocityEngine;
    private BocpConfigBuilder bocpConfigBuilder;

    public BoVelocityTemplateEngine init(BocpConfigBuilder bocpConfigBuilder) {
        this.bocpConfigBuilder = bocpConfigBuilder;
        if (null == this.velocityEngine) {
            Properties p = new Properties();
            p.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            p.setProperty("resource.loader.file.path", "");
            p.setProperty("UTF-8", ConstVal.UTF8);
            p.setProperty("resource.default_encoding", ConstVal.UTF8);
            p.setProperty("file.resource.loader.unicode", "true");
            this.velocityEngine = new VelocityEngine(p);
        }
        return this;
    }

    public void writer(Map<String, Object> objectMap, String templatePath, String outputFile) throws Exception {
        if (StringUtils.isEmpty((CharSequence)templatePath)) {
            return;
        }
        Template template = this.velocityEngine.getTemplate(templatePath, ConstVal.UTF8);
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             OutputStreamWriter ow = new OutputStreamWriter((OutputStream)fos, ConstVal.UTF8);
             BufferedWriter writer = new BufferedWriter(ow);){
            template.merge((Context)new VelocityContext(objectMap), (Writer)writer);
        }
        System.out.println("\u6a21\u677f:" + templatePath + ";  \u6587\u4ef6:" + outputFile);
        logger.debug("\u6a21\u677f:" + templatePath + ";  \u6587\u4ef6:" + outputFile);
    }

    public String templateFilePath(String filePath) {
        if (null == filePath || filePath.contains(DOT_VM)) {
            return filePath;
        }
        return filePath + DOT_VM;
    }

    public BoVelocityTemplateEngine batchOutput() {
        try {
            if (this.getBocpConfigBuilder().getStrategyConfig().getSuperEntityClass() != null && this.getBocpConfigBuilder().getBoConfig().getBaseEntity() != null) {
                TableInfo baseEntity = this.getBocpConfigBuilder().getBaseEntity();
                baseEntity.setCommonFields(new ArrayList());
                Map<String, Object> objectMap = this.getObjectMap(baseEntity);
                Map<String, String> pathInfo = this.getBocpConfigBuilder().getPathInfo();
                BocpTemplateConfig template = this.getBocpConfigBuilder().getBocpTemplate();
                String entityName = baseEntity.getEntityName();
                String baseEntityFile = String.format(pathInfo.get("base_entity_path") + File.separator + "%s" + this.suffixJavaOrKt(), entityName);
                this.writer(objectMap, this.templateFilePath(template.getBaseEntity(this.getBocpConfigBuilder().getGlobalConfig().isKotlin())), baseEntityFile);
            }
            List<TableInfo> tableInfoList = this.getBocpConfigBuilder().getTableInfoList();
            for (TableInfo tableInfo : tableInfoList) {
                Map<String, Object> objectMap = this.getObjectMap(tableInfo);
                Map<String, String> pathInfo = this.getBocpConfigBuilder().getPathInfo();
                BocpTemplateConfig template = this.getBocpConfigBuilder().getBocpTemplate();
                String entityName = tableInfo.getEntityName();
                if (null != entityName && null != pathInfo.get("entity_path")) {
                    String entityFile = String.format(pathInfo.get("entity_path") + File.separator + "%s" + this.suffixJavaOrKt(), entityName);
                    this.writer(objectMap, this.templateFilePath(template.getEntity(this.getBocpConfigBuilder().getGlobalConfig().isKotlin())), entityFile);
                }
                if (null != tableInfo.getMapperName() && null != pathInfo.get("mapper_path")) {
                    String mapperFile = String.format(pathInfo.get("mapper_path") + File.separator + tableInfo.getMapperName() + this.suffixJavaOrKt(), entityName);
                    this.writer(objectMap, this.templateFilePath(template.getMapper()), mapperFile);
                }
                if (null != tableInfo.getXmlName() && null != pathInfo.get("xml_path")) {
                    String xmlFile = String.format(pathInfo.get("xml_path") + File.separator + tableInfo.getXmlName() + ".xml", entityName);
                    this.writer(objectMap, this.templateFilePath(template.getXml()), xmlFile);
                }
                if (null != tableInfo.getServiceName() && null != pathInfo.get("service_path")) {
                    String serviceFile = String.format(pathInfo.get("service_path") + File.separator + tableInfo.getServiceName() + this.suffixJavaOrKt(), entityName);
                    this.writer(objectMap, this.templateFilePath(template.getService()), serviceFile);
                }
                if (null != tableInfo.getServiceImplName() && null != pathInfo.get("service_impl_path")) {
                    String implFile = String.format(pathInfo.get("service_impl_path") + File.separator + tableInfo.getServiceImplName() + this.suffixJavaOrKt(), entityName);
                    this.writer(objectMap, this.templateFilePath(template.getServiceImpl()), implFile);
                }
                if (null != tableInfo.getControllerName() && null != pathInfo.get("controller_path")) {
                    String controllerFile = String.format(pathInfo.get("controller_path") + File.separator + tableInfo.getControllerName() + this.suffixJavaOrKt(), entityName);
                    this.writer(objectMap, this.templateFilePath(template.getController()), controllerFile);
                }
                String feignFile = String.format(pathInfo.get("feign_path") + File.separator + "%s" + ".java", entityName + "FeignApi");
                this.writer(objectMap, this.templateFilePath(template.getFeign()), feignFile);
            }
        }
        catch (Exception e) {
            logger.error("\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01", (Throwable)e);
        }
        return this;
    }

    public BoVelocityTemplateEngine mkdirs() {
        this.getBocpConfigBuilder().getPathInfo().forEach((key, value) -> {
            boolean result;
            File dir = new File((String)value);
            if (!dir.exists() && (result = dir.mkdirs())) {
                logger.debug("\u521b\u5efa\u76ee\u5f55\uff1a [" + value + "]");
            }
        });
        return this;
    }

    public void open() {
        String outDir = this.getBocpConfigBuilder().getGlobalConfig().getOutputDir();
        if (this.getBocpConfigBuilder().getGlobalConfig().isOpen() && StringUtils.isNotEmpty((CharSequence)outDir)) {
            try {
                String osName = System.getProperty("os.name");
                if (osName != null) {
                    if (osName.contains("Mac")) {
                        Runtime.getRuntime().exec("open " + outDir);
                    } else if (osName.contains("Windows")) {
                        Runtime.getRuntime().exec("cmd /c start " + outDir);
                    } else {
                        logger.debug("\u6587\u4ef6\u8f93\u51fa\u76ee\u5f55:" + outDir);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Map<String, Object> getObjectMap(TableInfo tableInfo) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>(30);
        BocpConfigBuilder config = this.getBocpConfigBuilder();
        objectMap.put("restControllerStyle", config.getStrategyConfig().isRestControllerStyle());
        objectMap.put("config", config);
        objectMap.put("application", config.getApplicationConfig());
        objectMap.put("project", config.getProjectConfig());
        objectMap.put("module", config.getModuleConfig());
        objectMap.put("package", config.getPackageInfo());
        objectMap.put("dataSource", config.getDataSourceConfig());
        objectMap.put("servicename", StringUtils.firstToLowerCase((String)tableInfo.getServiceName()));
        objectMap.put("entityname", StringUtils.firstToLowerCase((String)tableInfo.getEntityName()));
        objectMap.put("serviceimplname", Introspector.decapitalize(tableInfo.getServiceImplName()));
        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put("author", globalConfig.getAuthor());
        objectMap.put("idType", globalConfig.getIdType() == null ? null : globalConfig.getIdType().toString());
        objectMap.put("logicDeleteFieldName", config.getStrategyConfig().getLogicDeleteFieldName());
        objectMap.put("versionFieldName", config.getStrategyConfig().getVersionFieldName());
        objectMap.put("activeRecord", globalConfig.isActiveRecord());
        objectMap.put("kotlin", globalConfig.isKotlin());
        objectMap.put("swagger2", globalConfig.isSwagger2());
        objectMap.put("date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        objectMap.put("table", tableInfo);
        objectMap.put("enableCache", globalConfig.isEnableCache());
        objectMap.put("baseResultMap", globalConfig.isBaseResultMap());
        objectMap.put("baseColumnList", globalConfig.isBaseColumnList());
        objectMap.put("entity", tableInfo.getEntityName());
        objectMap.put("entitySerialVersionUID", config.getStrategyConfig().isEntitySerialVersionUID());
        objectMap.put("entityColumnConstant", config.getStrategyConfig().isEntityColumnConstant());
        objectMap.put("entityBuilderModel", config.getStrategyConfig().isEntityBuilderModel());
        objectMap.put("entityLombokModel", config.getStrategyConfig().isEntityLombokModel());
        objectMap.put("entityBooleanColumnRemoveIsPrefix", config.getStrategyConfig().isEntityBooleanColumnRemoveIsPrefix());
        objectMap.put("superEntityClass", this.getSuperClassName(config.getSuperEntityClass()));
        objectMap.put("superMapperClassPackage", config.getSuperMapperClass());
        objectMap.put("superMapperClass", this.getSuperClassName(config.getSuperMapperClass()));
        objectMap.put("superServiceClassPackage", config.getSuperServiceClass());
        objectMap.put("superServiceClass", this.getSuperClassName(config.getSuperServiceClass()));
        objectMap.put("superServiceImplClassPackage", config.getSuperServiceImplClass());
        objectMap.put("superServiceImplClass", this.getSuperClassName(config.getSuperServiceImplClass()));
        objectMap.put("superControllerClassPackage", config.getSuperControllerClass());
        objectMap.put("superControllerClass", this.getSuperClassName(config.getSuperControllerClass()));
        objectMap.put("entityId", this.getBoId(config, tableInfo.getName()));
        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }

    private String getBoId(BocpConfigBuilder config, String boName) {
        List<Object> boGenInfos = config.getBoConfig().getBoGenInfoList() == null ? new ArrayList() : config.getBoConfig().getBoGenInfoList();
        Optional<BoGenInfo> optional = boGenInfos.stream().filter(boGenInfo -> boGenInfo.getName().equals(boName)).findFirst();
        Long id = null;
        if (optional.isPresent()) {
            id = optional.get().getId();
        }
        return id == null ? "" : id.toString();
    }

    private String getSuperClassName(String classPath) {
        if (StringUtils.isEmpty((CharSequence)classPath)) {
            return null;
        }
        return classPath.substring(classPath.lastIndexOf(".") + 1);
    }

    protected boolean isCreate(FileType fileType, String filePath) {
        BocpConfigBuilder cb = this.getBocpConfigBuilder();
        File file = new File(filePath);
        boolean exist = file.exists();
        if (!exist) {
            file.getParentFile().mkdirs();
        }
        return !exist || this.getBocpConfigBuilder().getGlobalConfig().isFileOverride();
    }

    protected String suffixJavaOrKt() {
        return this.getBocpConfigBuilder().getGlobalConfig().isKotlin() ? ".kt" : ".java";
    }

    public BocpConfigBuilder getBocpConfigBuilder() {
        return this.bocpConfigBuilder;
    }

    public void setBocpConfigBuilder(BocpConfigBuilder bocpConfigBuilder) {
        this.bocpConfigBuilder = bocpConfigBuilder;
    }
}

