import Mock from 'mockjs';
import { FIELD_TYPE } from './consts';

const Random = Mock.Random;
const RAMDOM_RANGE = 15;

const data = {};
export const mockEntities = (setting, enumValues) => {
  const basicEntity = {};
  const dependOnEntity = {};
  const entity = {};
  function addBasicEntity(entity) {
    entity.fields.forEach((field) => {
      if (field.type === FIELD_TYPE.RELATIONSHIP.code) {
        if (field.attribute.dependOn && field.attribute.dependOn.length) {
          dependOnEntity[field.relationshipEntity.id] = field.relationshipEntity.fields.concat(field.relationshipEntity.relationshipFields);
        } else {
          basicEntity[field.relationshipEntity.id] = field.relationshipEntity.fields;
        }
      }
    });
  }
  entity[setting.entityId] = setting.fields;
  addBasicEntity(setting);
  setting.subEntities.forEach((subEntity) => {
    entity[subEntity.id] = subEntity.fields.concat(subEntity.relationshipField);
    addBasicEntity(subEntity);
  });

  let id = 0;
  function generateRowData(fields, isBaseEntity) {
    return fields.reduce((rowData, field) => {
      const code = field.code;
      if (code === 'id') {
        return {
          ...rowData,
          [code]: id++,
        };
      }
      switch (field.type) {
        case FIELD_TYPE.STRING.code:
          return {
            ...rowData,
            [code]: /no$/.test(code.toLowerCase()) ? Random.string('number', 12) : Random.string(),
          };
        case FIELD_TYPE.NUMBER.code:
          return {
            ...rowData,
            [code]: Random.float(0, 99999, 0, 6),
          };
        case FIELD_TYPE.BOOLEAN.code:
          return {
            ...rowData,
            [code]: Random.boolean(),
          };
        case FIELD_TYPE.TIMESTAMP.code:
          return {
            ...rowData,
            [code]: new Date().valueOf() - Random.natural(0, 2592000000),
          };
        case FIELD_TYPE.ENUM.code:
          const enumOptions = enumValues[field.enumCode];
          const { value } = enumOptions[Random.natural(0, enumOptions.length - 1)];
          return {
            ...rowData,
            [code]: value,
          };
        case FIELD_TYPE.RELATIONSHIP.code:
          if (!isBaseEntity) {
            const fields = data[field.relationshipEntity.id];
            const index = Random.natural(0, fields.length - 1);
            return {
              ...rowData,
              [code]: fields[index].id,
            };
          }
          return rowData;
        default: return rowData;
      }
    }, {});
  }

  function generateDataList(fields, isBaseEntity) {
    const result = [];
    const LIST_LEN = Math.round(Math.random() * RAMDOM_RANGE + RAMDOM_RANGE);
    id = 0;
    for (let i = 0; i < LIST_LEN; i++) {
      result.push(generateRowData(fields, isBaseEntity));
    }
    return result;
  }

  Object.keys(basicEntity).forEach((key) => {
    data[key] = generateDataList(basicEntity[key], true);
  });

  Object.keys(dependOnEntity).forEach((key) => {
    data[key] = generateDataList(dependOnEntity[key]);
  });

  Object.keys(entity).forEach((key) => {
    data[key] = generateDataList(entity[key]);
  });
  return data;
};

const createEntity = (entityId, row) => {
  const id = data[entityId].length > 0 ? data[entityId][data[entityId].length - 1].id + 1 : 0;
  data[entityId].push({
    id,
    ...row,
  });
};

const updateEntity = (entityId, row) => {
  const index = data[entityId].findIndex(({ id }) => String(row.id) === String(id));
  if (index > -1) {
    data[entityId].splice(index, 1, {
      ...data[entityId][index],
      ...row,
    });
  }
};

const deleteEntity = (entityId, id) => {
  const index = data[entityId].findIndex(row => String(row.id) === String(id));
  if (index > -1) {
    data[entityId].splice(index, 1);
  }
};

export {
  createEntity,
  updateEntity,
  deleteEntity,
};
