package com.xforceplus.ultraman.bocp.gen.config;

import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
public class BocpTemplateConfig {
    private static final long serialVersionUID = 1L;
    //Application配置
    private String gitignore = BocpConstVal.TEMPLATE_GITIGNORE;
    private String gitlab = BocpConstVal.TEMPLATE_GITLAB_CI_YML;
    private String applicationYml = BocpConstVal.TEMPLATE_APPLICATION_YML;
    private String clientPom = BocpConstVal.TEMPLATE_CLIENT_POM_XML;
    private String applicationPom = BocpConstVal.TEMPLATE_POM_XML;
    private String applicationParentPom = BocpConstVal.TEMPLATE_PARENT_POM_XML;
    private String servicePom = BocpConstVal.TEMPLATE_SERVICE_POM_XML;
    private String serviceApplication = BocpConstVal.TEMPLATE_SERVICEAPPLICATION_JAVA;
    private String serviceApplicationTest = BocpConstVal.TEMPLATE_SERVICEAPPLICATIONTESTS_JAVA;

    //Module配置
    private String moduleGitignore = BocpConstVal.TEMPLATE_MODULE_GITIGNORE;
    private String moduleGitlab = BocpConstVal.TEMPLATE_MODULE_GITLAB_CI_YML;
    private String moduleApplicationYml = BocpConstVal.TEMPLATE_MODULE_YML;
    private String moduleClientPom = BocpConstVal.TEMPLATE_MODULE_CLIENT_POM_XML;
    private String modulePom = BocpConstVal.TEMPLATE_MODULE_POM_XML;
    private String moduleParentPom = BocpConstVal.TEMPLATE_MODULE_PARENT_POM_XML;
    private String moduleDomainPom = BocpConstVal.TEMPLATE_MODULE_DOMAIN_POM_XML;
    private String moduleServicePom = BocpConstVal.TEMPLATE_MODULE_SERVICE_POM_XML;
    private String moduleServiceApplication = BocpConstVal.TEMPLATE_MODULE_SERVICEAPPLICATION_JAVA;
    private String moduleServiceApplicationTest = BocpConstVal.TEMPLATE_MODULE_SERVICEAPPLICATIONTESTS_JAVA;

    //BO配置
    @Getter(AccessLevel.NONE)
    private String entity = BocpConstVal.TEMPLATE_ENTITY_JAVA;
    private String entityKt = BocpConstVal.TEMPLATE_ENTITY_KT;
    private String service = BocpConstVal.TEMPLATE_SERVICE;
    private String serviceImpl = BocpConstVal.TEMPLATE_SERVICE_IMPL;
    private String mapper = BocpConstVal.TEMPLATE_MAPPER;
    private String xml = BocpConstVal.TEMPLATE_XML;
    private String controller = BocpConstVal.TEMPLATE_CONTROLLER;
    private String feign = BocpConstVal.TEMPLATE_FEIGN;
    public String getEntity(boolean kotlin) {
        return kotlin ? entityKt : entity;
    }

    //ENUM配置
    private String enume = BocpConstVal.TEMPLATE_ENUM_JAVA;
    private String enumKt = BocpConstVal.TEMPLATE_ENUM_KT;
    public String getEnum(boolean kotlin) {
        return kotlin ? enumKt : enume;
    }

    //BaseEntity配置
    @Getter(AccessLevel.NONE)
    private String baseEntity = BocpConstVal.TEMPLATE_BASE_ENTITY_JAVA;
    private String baseEntityKt = BocpConstVal.TEMPLATE_BASE_ENTITY_KT;
    public String getBaseEntity(boolean kotlin) {
        return kotlin ? baseEntityKt : baseEntity;
    }

    //DTO配置
    @Getter(AccessLevel.NONE)
    private String dto = BocpConstVal.TEMPLATE_DTO_JAVA;
    private String dtoKt = BocpConstVal.TEMPLATE_DTO_KT;
    public String getDto(boolean kotlin) {
        return kotlin ? dtoKt : dto;
    }

}
