package com.xforceplus.ultraman.bocp.gen.engine;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.xforceplus.ultraman.bocp.gen.config.BocpConfigBuilder;
import com.xforceplus.ultraman.bocp.gen.config.BocpConstVal;
import com.xforceplus.ultraman.bocp.gen.config.BocpTemplateConfig;
import com.xforceplus.ultraman.bocp.gen.config.ConstValEx;
import com.xforceplus.ultraman.bocp.gen.po.BoGenInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.beans.Introspector;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.*;

public class BoVelocityTemplateEngine extends VelocityTemplateEngine {
    protected static final Logger logger = LoggerFactory.getLogger(BoVelocityTemplateEngine.class);

    /**
     * 输出 java xml 文件
     */
    @Override
    public BoVelocityTemplateEngine batchOutput() {
        try {
            if(getBocpConfigBuilder().getStrategyConfig().getSuperEntityClass() != null
                    && getBocpConfigBuilder().getBoConfig().getBaseEntity() != null) {
                TableInfo baseEntity =  getBocpConfigBuilder().getBaseEntity();
                baseEntity.setCommonFields(new ArrayList<>());
                Map<String, Object> objectMap = getObjectMap(baseEntity);
                Map<String, String> pathInfo = getBocpConfigBuilder().getPathInfo();
                BocpTemplateConfig template = getBocpConfigBuilder().getBocpTemplate();
                String entityName = baseEntity.getEntityName();
                String baseEntityFile = String.format((pathInfo.get(ConstValEx.BASE_ENTITY_PATH) + File.separator + "%s" + suffixJavaOrKt()), entityName);
                writer(objectMap, templateFilePath(template.getBaseEntity(getBocpConfigBuilder().getGlobalConfig().isKotlin())), baseEntityFile
                );
            }


            List<TableInfo> tableInfoList = getBocpConfigBuilder().getTableInfoList();
            for (TableInfo tableInfo : tableInfoList) {
                Map<String, Object> objectMap = getObjectMap(tableInfo);
                Map<String, String> pathInfo = getBocpConfigBuilder().getPathInfo();
                BocpTemplateConfig template = getBocpConfigBuilder().getBocpTemplate();

                // Mp.java
                String entityName = tableInfo.getEntityName();
                if (null != entityName && null != pathInfo.get(ConstVal.ENTITY_PATH)) {
                    String entityFile = String.format((pathInfo.get(ConstVal.ENTITY_PATH) + File.separator + "%s" + suffixJavaOrKt()), entityName);
                    writer(objectMap, templateFilePath(template.getEntity(getBocpConfigBuilder().getGlobalConfig().isKotlin())), entityFile);
//                    if (isCreate(FileType.ENTITY, entityFile)) {
//                        writer(objectMap, templateFilePath(template.getEntity(getBocpConfigBuilder().getGlobalConfig().isKotlin())), entityFile);
//                    }
                }
                // MpMapper.java
                if (null != tableInfo.getMapperName() && null != pathInfo.get(ConstVal.MAPPER_PATH)) {
                    String mapperFile = String.format((pathInfo.get(ConstVal.MAPPER_PATH) + File.separator + tableInfo.getMapperName() + suffixJavaOrKt()), entityName);
                    writer(objectMap, templateFilePath(template.getMapper()), mapperFile);
//                    if (isCreate(FileType.MAPPER, mapperFile)) {
//                        writer(objectMap, templateFilePath(template.getMapper()), mapperFile);
//                    }
                }
                // MpMapper.xml
                if (null != tableInfo.getXmlName() && null != pathInfo.get(ConstVal.XML_PATH)) {
                    String xmlFile = String.format((pathInfo.get(ConstVal.XML_PATH) + File.separator + tableInfo.getXmlName() + ConstVal.XML_SUFFIX), entityName);
                    writer(objectMap, templateFilePath(template.getXml()), xmlFile);
//                    if (isCreate(FileType.XML, xmlFile)) {
//                        writer(objectMap, templateFilePath(template.getXml()), xmlFile);
//                    }
                }
                // IMpService.java
                if (null != tableInfo.getServiceName() && null != pathInfo.get(ConstVal.SERVICE_PATH)) {
                    String serviceFile = String.format((pathInfo.get(ConstVal.SERVICE_PATH) + File.separator + tableInfo.getServiceName() + suffixJavaOrKt()), entityName);
                    writer(objectMap, templateFilePath(template.getService()), serviceFile);
//                    if (isCreate(FileType.SERVICE, serviceFile)) {
//                        writer(objectMap, templateFilePath(template.getService()), serviceFile);
//                    }
                }
                // MpServiceImpl.java
                if (null != tableInfo.getServiceImplName() && null != pathInfo.get(ConstVal.SERVICE_IMPL_PATH)) {
                    String implFile = String.format((pathInfo.get(ConstVal.SERVICE_IMPL_PATH) + File.separator + tableInfo.getServiceImplName() + suffixJavaOrKt()), entityName);
                    writer(objectMap, templateFilePath(template.getServiceImpl()), implFile);
//                    if (isCreate(FileType.SERVICE_IMPL, implFile)) {
//                        writer(objectMap, templateFilePath(template.getServiceImpl()), implFile);
//                    }
                }
                // MpController.java
                if (null != tableInfo.getControllerName() && null != pathInfo.get(ConstVal.CONTROLLER_PATH)) {
                    String controllerFile = String.format((pathInfo.get(ConstVal.CONTROLLER_PATH) + File.separator + tableInfo.getControllerName() + suffixJavaOrKt()), entityName);
                    writer(objectMap, templateFilePath(template.getController()), controllerFile);
//                    if (isCreate(FileType.CONTROLLER, controllerFile)) {
//                        writer(objectMap, templateFilePath(template.getController()), controllerFile);
//                    }
                }
                // Feign.java
                String feignFile = String.format((pathInfo.get(BocpConstVal.FEIGN_PATH) + File.separator + "%s" + ConstVal.JAVA_SUFFIX), entityName + "FeignApi");
                writer(objectMap, templateFilePath(template.getFeign()), feignFile);

            }
        } catch (Exception e) {
            logger.error("无法创建文件，请检查配置信息！", e);
        }
        return this;
    }

    /**
     * 渲染对象 MAP 信息
     *
     * @param tableInfo 表信息对象
     * @return ignore
     */
    public Map<String, Object> getObjectMap(TableInfo tableInfo) {
        Map<String, Object> objectMap = new HashMap<>(30);
        BocpConfigBuilder config = getBocpConfigBuilder();
        //将参数放入map中用于模板解析
        objectMap.put("restControllerStyle", config. getStrategyConfig().isRestControllerStyle());
        objectMap.put("config", config);
        objectMap.put("application", config.getApplicationConfig());
        objectMap.put("project", config.getProjectConfig());
        objectMap.put("module", config.getModuleConfig());
        objectMap.put("package", config.getPackageInfo());
        objectMap.put("dataSource", config.getDataSourceConfig());
        objectMap.put("servicename",StringUtils.firstToLowerCase(tableInfo.getServiceName()));
        objectMap.put("entityname",StringUtils.firstToLowerCase(tableInfo.getEntityName()));
        objectMap.put("serviceimplname",Introspector.decapitalize(tableInfo.getServiceImplName()));
        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put("author", globalConfig.getAuthor());
        objectMap.put("idType", globalConfig.getIdType() == null ? null : globalConfig.getIdType().toString());
        objectMap.put("logicDeleteFieldName", config.getStrategyConfig().getLogicDeleteFieldName());
        objectMap.put("versionFieldName", config.getStrategyConfig().getVersionFieldName());
        objectMap.put("activeRecord", globalConfig.isActiveRecord());
        objectMap.put("kotlin", globalConfig.isKotlin());
        objectMap.put("swagger2", globalConfig.isSwagger2());
        objectMap.put("date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        objectMap.put("table", tableInfo);
        objectMap.put("enableCache", globalConfig.isEnableCache());
        objectMap.put("baseResultMap", globalConfig.isBaseResultMap());
        objectMap.put("baseColumnList", globalConfig.isBaseColumnList());
        objectMap.put("entity", tableInfo.getEntityName());
        objectMap.put("entitySerialVersionUID", config.getStrategyConfig().isEntitySerialVersionUID());
        objectMap.put("entityColumnConstant", config.getStrategyConfig().isEntityColumnConstant());
        objectMap.put("entityBuilderModel", config.getStrategyConfig().isEntityBuilderModel());
        objectMap.put("entityLombokModel", config.getStrategyConfig().isEntityLombokModel());
        objectMap.put("entityBooleanColumnRemoveIsPrefix", config.getStrategyConfig().isEntityBooleanColumnRemoveIsPrefix());
        objectMap.put("superEntityClass", getSuperClassName(config.getSuperEntityClass()));
        objectMap.put("superMapperClassPackage", config.getSuperMapperClass());
        objectMap.put("superMapperClass", getSuperClassName(config.getSuperMapperClass()));
        objectMap.put("superServiceClassPackage", config.getSuperServiceClass());
        objectMap.put("superServiceClass", getSuperClassName(config.getSuperServiceClass()));
        objectMap.put("superServiceImplClassPackage", config.getSuperServiceImplClass());
        objectMap.put("superServiceImplClass", getSuperClassName(config.getSuperServiceImplClass()));
        objectMap.put("superControllerClassPackage", config.getSuperControllerClass());
        objectMap.put("superControllerClass", getSuperClassName(config.getSuperControllerClass()));
        objectMap.put("entityId", getBoId(config, tableInfo.getName()));

        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }

    /**
     * 对象固定Id
     */
    private String getBoId(BocpConfigBuilder config, String boName){
        List<BoGenInfo> boGenInfos = config.getBoConfig().getBoGenInfoList() == null
                ? new ArrayList<>():config.getBoConfig().getBoGenInfoList();

        Optional<BoGenInfo> optional = boGenInfos.stream()
                .filter(boGenInfo -> boGenInfo.getName().equals(boName)).findFirst();
        Long id = null;
        if(optional.isPresent()) {
            id = optional.get().getId();
        }
        return id == null ? "" : id.toString();
    }

}
