package com.xforceplus.ultraman.bocp.gen.engine;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.xforceplus.ultraman.bocp.gen.config.BocpConfigBuilder;
import com.xforceplus.ultraman.bocp.gen.config.BocpConstVal;
import com.xforceplus.ultraman.bocp.gen.config.BocpTemplateConfig;
import com.xforceplus.ultraman.bocp.gen.po.DtoGenInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.*;

public class DtoVelocityTemplateEngine extends VelocityTemplateEngine {
    protected static final Logger logger = LoggerFactory.getLogger(DtoVelocityTemplateEngine.class);

    /**
     * 输出 java xml 文件
     */
    @Override
    public DtoVelocityTemplateEngine batchOutput() {
        try {
            if (getBocpConfigBuilder().getDtoConfig() != null && getBocpConfigBuilder().getDtoConfig().getDtoGenInfos() != null) {
                List<DtoGenInfo> dtoGenInfoList = getBocpConfigBuilder().getDtoConfig().getDtoGenInfos();
                for (DtoGenInfo dtoGenInfo : dtoGenInfoList) {
                    Map<String, Object> objectMap = getObjectMap(dtoGenInfo);
                    Map<String, String> pathInfo = getBocpConfigBuilder().getPathInfo();
                    BocpTemplateConfig template = getBocpConfigBuilder().getBocpTemplate();

                    // Mp.java
                    String dtoName = StringUtils.capitalize(dtoGenInfo.getCode());
                    if (null != dtoName && null != pathInfo.get(BocpConstVal.DTO_PATH)) {
                        String dtoFile = String.format((pathInfo.get(BocpConstVal.DTO_PATH) + File.separator + "%s" + suffixJavaOrKt()), dtoName);
                        writer(objectMap, templateFilePath(template.getDto(getBocpConfigBuilder().getGlobalConfig().isKotlin())), dtoFile);
                    }
                }
            }
        } catch (Exception e) {
            logger.error("无法创建文件，请检查配置信息！", e);
        }
        return this;
    }

    /**
     * 渲染对象 MAP 信息
     *
     * @param dtoGenInfo 表信息对象
     * @return ignore
     */
    public Map<String, Object> getObjectMap(DtoGenInfo dtoGenInfo) {
        Map<String, Object> objectMap = new HashMap<>(30);
        BocpConfigBuilder config = getBocpConfigBuilder();
        //将参数放入map中用于模板解析

        objectMap.put("config", config);
        objectMap.put("application", config.getApplicationConfig());
        objectMap.put("project", config.getProjectConfig());
        objectMap.put("module", config.getModuleConfig());
        objectMap.put("package", config.getPackageInfo());
        objectMap.put("dataSource", config.getDataSourceConfig());
        objectMap.put("dtoname", StringUtils.capitalize(dtoGenInfo.getCode()));

        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put("author", globalConfig.getAuthor());
        objectMap.put("kotlin", globalConfig.isKotlin());

        objectMap.put("date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        objectMap.put("enableCache", globalConfig.isEnableCache());
        objectMap.put("dtoInfo", dtoGenInfo);
        objectMap.put("dto", dtoGenInfo.getCode());
        objectMap.put("dtoSerialVersionUID", config.getStrategyConfig().isEntitySerialVersionUID());
        objectMap.put("dtoColumnConstant", config.getStrategyConfig().isEntityColumnConstant());
        objectMap.put("dtoBuilderModel", config.getStrategyConfig().isEntityBuilderModel());
        objectMap.put("dtoLombokModel", config.getStrategyConfig().isEntityLombokModel());
        objectMap.put("dtoBooleanColumnRemoveIsPrefix", config.getStrategyConfig().isEntityBooleanColumnRemoveIsPrefix());

        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }

}
