package com.xforceplus.ultraman.bocp.gen.engine;

import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.xforceplus.ultraman.bocp.gen.config.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ModuleVelocityTemplateEngine extends VelocityTemplateEngine {
    protected static final Logger logger = LoggerFactory.getLogger(ModuleVelocityTemplateEngine.class);

    /**
     * 输出 java xml 文件
     */
    @Override
    public ModuleVelocityTemplateEngine batchOutput() {
        try {
            ModuleConfig moduleConfig = getBocpConfigBuilder().getModuleConfig();
            ApplicationConfig applicationConfig = getBocpConfigBuilder().getApplicationConfig();
            Map<String, String> pathInfo = getBocpConfigBuilder().getPathInfo();
            BocpTemplateConfig template = getBocpConfigBuilder().getBocpTemplate();
            if (null != moduleConfig.getName() && null != applicationConfig.getName()) {
                Map<String, Object> objectMap = getObjectMap();
                String parentPomFile = String.format(pathInfo.get(BocpConstVal.MODULE_PARENT_POM_PATH) + File.separator + "%s" + ConstVal.XML_SUFFIX, "pom");
                writer(objectMap, templateFilePath(template.getModuleParentPom()), parentPomFile);

                String gitigoreFile = String.format(pathInfo.get(BocpConstVal.MODULE_GITIGNORE_PATH) + File.separator + "%s", ".gitigore");
                writer(objectMap, templateFilePath(template.getModuleGitignore()), gitigoreFile);

                String gitlabCiYmlFile = String.format(pathInfo.get(BocpConstVal.MODULE_GITLAB_PATH) + File.separator + "%s" + BocpConstVal.YML_SUFFIX, ".gitlab-ci");
                writer(objectMap, templateFilePath(template.getModuleGitlab()), gitlabCiYmlFile);

                String applicationYmlFile =  String.format(pathInfo.get(BocpConstVal.MODULE_APPLICATION_YML_PATH) + File.separator + "%s" + BocpConstVal.YML_SUFFIX, "application");
                writer(objectMap, templateFilePath(template.getModuleApplicationYml()), applicationYmlFile);

                String clientPomFile = String.format(pathInfo.get(BocpConstVal.MODULE_CLIENT_POM_PATH) + File.separator + "%s" + ConstVal.XML_SUFFIX, "pom");
                writer(objectMap, templateFilePath(template.getModuleClientPom()), clientPomFile);

                String pomFile = String.format(pathInfo.get(BocpConstVal.MODULE_POM_PATH) + File.separator + "%s" + ConstVal.XML_SUFFIX, "pom");
                writer(objectMap, templateFilePath(template.getModulePom()), pomFile);

                String servicePomFile = String.format(pathInfo.get(BocpConstVal.MODULE_SERVICE_POM_PATH) + File.separator + "%s" + ConstVal.XML_SUFFIX, "pom");
                writer(objectMap, templateFilePath(template.getModuleServicePom()), servicePomFile);

                String domainPomFile = String.format(pathInfo.get(BocpConstVal.MODULE_DOMAIN_POM_PATH) + File.separator + "%s" + ConstVal.XML_SUFFIX, "pom");
                writer(objectMap, templateFilePath(template.getModuleDomainPom()), domainPomFile);

//                String serviceApplicationFile = String.format(pathInfo.get(BocpConstVal.MODULE_SERVICE_APPLICATION_PATH) + File.separator + "%s" + ConstVal.JAVA_SUFFIX, moduleConfig.getAlias() + "ServiceApplication");
//                writer(objectMap, templateFilePath(template.getModuleServiceApplication()), serviceApplicationFile);
            }
        } catch (Exception e) {
            logger.error("无法创建文件，请检查配置信息！", e);
        }
        return this;
    }

    /**
     * 渲染对象 MAP 信息
     *
     *
     * @return ignore
     */
    public Map<String, Object> getObjectMap() {
        Map<String, Object> objectMap = new HashMap<>(30);
        BocpConfigBuilder config = getBocpConfigBuilder();
        //将参数放入map中用于模板解析
        objectMap.put("config", config);
        objectMap.put("application", config.getApplicationConfig());
        objectMap.put("project", config.getProjectConfig());
        objectMap.put("module", config.getModuleConfig());
        objectMap.put("package", config.getPackageInfo());
        objectMap.put("dataSource", config.getDataSourceConfig());
        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put("author", globalConfig.getAuthor());
        objectMap.put("idType", globalConfig.getIdType() == null ? null : globalConfig.getIdType().toString());
        objectMap.put("logicDeleteFieldName", config.getStrategyConfig().getLogicDeleteFieldName());
        objectMap.put("versionFieldName", config.getStrategyConfig().getVersionFieldName());
        objectMap.put("activeRecord", globalConfig.isActiveRecord());
        objectMap.put("kotlin", globalConfig.isKotlin());
        objectMap.put("swagger2", globalConfig.isSwagger2());
        objectMap.put("date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }

}
