package com.xforceplus.ultraman.bocp.gen.generator;

import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.generator.config.*;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.xforceplus.ultraman.bocp.gen.config.*;
import com.xforceplus.ultraman.bocp.gen.constant.EngineType;
import com.xforceplus.ultraman.bocp.gen.engine.*;
import com.xforceplus.ultraman.bocp.gen.util.FileUtil;
import lombok.AccessLevel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

@Data
public class BocpAutoGenerator {
    private static final Logger logger = LoggerFactory.getLogger(BocpAutoGenerator.class);

    /**
     * 模板 相关配置
     */
    private BocpTemplateConfig template;
    /**
     * 项目相关配置
     */
    private ProjectConfig projectConfig;
    /**
     * 应用信息配置
     */
    private ApplicationConfig applicationConfig;
    /**
     * 模块相关配置
     */
    private ModuleConfig moduleConfig;

    /**
     * 配置信息
     */
    protected BocpConfigBuilder bocpConfig;

    /**
     * 业务对象相关配置
     */
    private BoConfig boConfig;

    /**
     * 字典相关配置
     */
    private DictConfig dictConfig;

    /**
     * DTO相关配置
     */
    private DtoConfig dtoConfig;

    /**
     * 数据源配置
     */
    private DataSourceConfig dataSource;
    /**
     * 数据库表配置
     */
    private StrategyConfig strategy;
    /**
     * 包 相关配置
     */
    private PackageConfig packageInfo;

    /**
     * 全局 相关配置
     */
    private GlobalConfig globalConfig;

    /**
     * 模板工厂
     */
    @Getter(AccessLevel.NONE)
    @Setter(AccessLevel.NONE)
    private VelocityTemplateEngineFactory templateEngineFactory;
    /**
     * 使用模板类型templateEngineFactory = new VelocityTemplateEngineFactory();
     */
    private String engineType;

    public BocpAutoGenerator(){
        templateEngineFactory = new VelocityTemplateEngineFactory();
    }

    /**
     * 生成代码
     */
    public void execute() {
        logger.debug("==========================准备生成文件...==========================");
        // 初始化配置
        if (null == bocpConfig) {
            bocpConfig = new BocpConfigBuilder(projectConfig, applicationConfig, moduleConfig, boConfig, dictConfig, dtoConfig, packageInfo, dataSource, strategy, template, globalConfig);
//            if (null != injectionConfig) {
//                injectionConfig.setConfig(bocpConfig);
//            }
        }
        Map<String, String> pathInfo = this.pretreatmentConfigBuilder(bocpConfig).getPathInfo();

        if(engineType == null || Arrays.asList(new String[]{BocpConstVal.APPLICATIONENGINE, BocpConstVal.MODULEENGINE}).contains(engineType)) {
            //清理上一次代码
            FileUtil.delAllFile(pathInfo.get(BocpConstVal.PARENT_POM_PATH));
        }

        //不指定就默认使用原有的模板引擎
        if (engineType == null) {
            Arrays.asList(new String[]{BocpConstVal.APPLICATIONENGINE, BocpConstVal.MODULEENGINE,
                            BocpConstVal.BOENGINE, BocpConstVal.DICTENGINE, BocpConstVal.DTOENGINE})
                    .forEach(type -> doExecute(type));
        } else {
            doExecute(engineType);
        }
    }

    void doExecute(String type){
        VelocityTemplateEngine engine = templateEngineFactory.getVelocityTemplateEngine(type);
        if(engine != null) {
            templateEngineFactory.getVelocityTemplateEngine(engineType).init(this.pretreatmentConfigBuilder(bocpConfig)).mkdirs().batchOutput().open();
            logger.debug(String.format("==========================%s文件生成完成！！！==========================", EngineType.fromCode(type).name()));
        } else {
            logger.debug(String.format("==========================%s文件生成失败，找不到模板引擎！！！==========================", EngineType.fromCode(type).name()));
        }
    }

    /**
     * 开放表信息、预留子类重写
     *
     * @param bocpConfig 配置信息
     * @return ignore
     */
    protected List<TableInfo> getAllTableInfoList(BocpConfigBuilder bocpConfig) {
        return bocpConfig.getTableInfoList();
    }

    /**
     * 预处理配置
     *
     * @param bocpconfig 总配置信息
     * @return 解析数据结果集
     */
    protected BocpConfigBuilder pretreatmentConfigBuilder(BocpConfigBuilder bocpconfig) {
        /*
         * 表信息列表
         */
        List<TableInfo> tableList = this.getAllTableInfoList(bocpconfig);
        if(tableList != null) {
            for (TableInfo tableInfo : tableList) {
                /* ---------- 添加导入包 ---------- */
                if (bocpConfig.getGlobalConfig().isActiveRecord()) {
                    // 开启 ActiveRecord 模式
                    tableInfo.setImportPackages(Model.class.getCanonicalName());
                }
                if (tableInfo.isConvert()) {
                    // 表注解
                    tableInfo.setImportPackages(TableName.class.getCanonicalName());
                }
                if (bocpConfig.getStrategyConfig().getLogicDeleteFieldName() != null && tableInfo.isLogicDelete(bocpconfig.getStrategyConfig().getLogicDeleteFieldName())) {
                    // 逻辑删除注解
                    tableInfo.setImportPackages(TableLogic.class.getCanonicalName());
                }
                if (StringUtils.isNotEmpty(bocpconfig.getStrategyConfig().getVersionFieldName())) {
                    // 乐观锁注解
                    tableInfo.setImportPackages(Version.class.getCanonicalName());
                }
                boolean importSerializable = true;
                if (StringUtils.isNotEmpty(bocpconfig.getSuperEntityClass())) {
                    // 父实体
                    tableInfo.setImportPackages(bocpconfig.getSuperEntityClass());
                    importSerializable = false;
                }
                if (bocpconfig.getGlobalConfig().isActiveRecord()) {
                    importSerializable = true;
                }
                if (importSerializable) {
                    tableInfo.setImportPackages(Serializable.class.getCanonicalName());
                }
                // Boolean类型is前缀处理
                if (bocpconfig.getStrategyConfig().isEntityBooleanColumnRemoveIsPrefix()
                        && CollectionUtils.isNotEmpty(tableInfo.getFields())) {
                    tableInfo.getFields().stream().filter(field -> "boolean".equalsIgnoreCase(field.getPropertyType()))
                            .filter(field -> field.getPropertyName().startsWith("is"))
                            .forEach(field -> {
                                field.setConvert(true);
                                field.setPropertyName(StringUtils.removePrefixAfterPrefixToLower(field.getPropertyName(), 2));
                            });
                }
            }
        }
        return bocpconfig.setTableInfoList(tableList);
    }

}
