package com.xforceplus.ultraman.bocp.gen.util;

import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.xforceplus.ultraman.bocp.gen.config.*;
import com.xforceplus.ultraman.bocp.gen.generator.BocpAutoGenerator;
import com.xforceplus.ultraman.bocp.gen.po.*;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * mysql 代码生成器演示例子
 * </p>
 *
 * @author wangzheng
 * @since 2019-11-19
 */
public class DictGenerator {

    /**
     * RUN THIS
     */
    public static void main(String[] args) {

        // 代码生成器
        BocpAutoGenerator mpg = new BocpAutoGenerator();
        // 全局配置
        GlobalConfig gc = new GlobalConfig();
        gc.setAuthor("youyifan");
        gc.setBaseResultMap(true);
        gc.setOpen(false);
        mpg.setGlobalConfig(gc);

        // 数据源配置
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setUrl("jdbc:mysql://120.55.249.44:27306/bocp?useUnicode=true&serverTimezone=GMT&useSSL=false&characterEncoding=utf8");
        // dsc.setSchemaName("public");
        dsc.setDriverName("com.mysql.jdbc.Driver");
        dsc.setUsername("root");
        dsc.setPassword("xplat");
        mpg.setDataSource(dsc);

        // 项目配置
        ProjectConfig prjc = new ProjectConfig();
        prjc.setName("ultraman");
        prjc.setCode("ULTRAMAN");
        prjc.setGroupInfo("com.xforceplus");
        prjc.setRemark("ultraman is a platform");
        prjc.setVersion("0.1.14");
        mpg.setProjectConfig(prjc);

        // 应用配置
        ApplicationConfig appc = new ApplicationConfig();
        appc.setName("ultraman-bocp");
        appc.setAlias("Bocp");
        appc.setCode("BOCP");
        appc.setRemark("Bocp is a low code platform");
        appc.setVersion("0.1.14");
        appc.setUrl("https://xxx.gitlab.com/digital");
        ModuleInfo mdi = new ModuleInfo();
        mdi.setName("ultraman-bocp-metadata");
        mdi.setAlias("Metadata");
        List<ModuleInfo> mdiList = new ArrayList<>();
        mdiList.add(mdi);
        appc.setModuleList(mdiList);
        mpg.setApplicationConfig(appc);

        //模块配置
        ModuleConfig mdc = new ModuleConfig();
        mdc.setName("ultraman-bocp-metadata");
        mdc.setAlias("Metadata");
        mdc.setCode("METADATA");
        mdc.setModuleType("sys");
        mdc.setVersion("0.1.14");
        mpg.setModuleConfig(mdc);

        // 包配置
        PackageConfig pc = new PackageConfig();
        pc.setModuleName("metadata");
        pc.setParent("com.xforceplus.ultraman.bocp");
        mpg.setPackageInfo(pc);

        BoConfig bo = new BoConfig();
        List<BoGenInfo> boGenInfos = new ArrayList<>();
        BoGenInfo boGenInfo = new BoGenInfo();
        boGenInfo.setName("coTest");
        boGenInfo.setRemark("Test");
        boGenInfo.setAlias("Botest");
        boGenInfo.setBoType("sys");
        boGenInfo.setCode("BOTEST");
        List<BoGenField> boGenFields = new ArrayList<>();
        BoGenField boGenField = new BoGenField();
        boGenField.setName("id");
        boGenField.setAlias("id");
        boGenField.setFieldKey("1");
        boGenField.setFiledType("varchar");
        boGenField.setRemark("key");
        boGenField.setNullKey("1");
        BoGenField boGenField1 = new BoGenField();
        boGenField1.setName("name");
        boGenField1.setAlias("name");
        boGenField1.setRemark("name");
        boGenField1.setFiledType("varchar");
        boGenFields.add(boGenField);
        boGenFields.add(boGenField1);
        boGenInfo.setBoGenFieldList(boGenFields);
        boGenInfos.add(boGenInfo);
//        bo.setBoInfoList(boInfos);
        bo.setFromDB(false);
        mpg.setBoConfig(bo);

        //DictConfig
        DictConfig dictConfg = new DictConfig();
        DictGenInfo dictGenInfo = new DictGenInfo();
        dictGenInfo.setCode("Zoo");
        dictGenInfo.setName("动物园");
        List<DictGenOption> options = new ArrayList<>();
        DictGenOption option = new DictGenOption();
        option.setCode("_0_01");
        option.setName("0.01");
        option.setValue("0.01");
        options.add(option);
        DictGenOption option2 = new DictGenOption();
        option2.setCode("_0_02");
        option2.setName("0.02");
        option2.setValue("0.02");
        options.add(option2);
        dictGenInfo.setOptions(options);
        List<DictGenInfo> dictGenInfos = new ArrayList<>();
        dictGenInfos.add(dictGenInfo);
        dictConfg.setDictGenInfos(dictGenInfos);
        mpg.setDictConfig(dictConfg);

        // 策略配置
        StrategyConfig strategy = new StrategyConfig();
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setEntityLombokModel(true);
//        strategy.setEntityTableFieldAnnotationEnable(true);
        strategy.setControllerMappingHyphenStyle(true);
        strategy.setTablePrefix(pc.getModuleName() + "_");
        NameConvert nameConvert = new NameConvert();
        strategy.setNameConvert(nameConvert);
        mpg.setStrategy(strategy);
        mpg.setEngineType("dict");
        mpg.execute();

    }

}
