package com.xforceplus.ultraman.bocp.gen.util;

import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.xforceplus.ultraman.bocp.gen.config.*;
import com.xforceplus.ultraman.bocp.gen.constant.CodeGenConstant;
import com.xforceplus.ultraman.bocp.gen.generator.BocpAutoGenerator;
import com.xforceplus.ultraman.bocp.gen.po.*;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * mysql 代码生成器演示例子
 * </p>
 *
 * @author wangzheng
 * @since 2019-11-19
 */
public class DtoGenerator {

    /**
     * RUN THIS
     */
    public static void main(String[] args) {

        // 代码生成器
        BocpAutoGenerator mpg = new BocpAutoGenerator();
        // 全局配置
        GlobalConfig gc = new GlobalConfig();
        gc.setAuthor("xx");
        gc.setBaseResultMap(true);
        gc.setOpen(false);
        mpg.setGlobalConfig(gc);

        // 项目配置
        ProjectConfig prjc = new ProjectConfig();
        prjc.setName("ultraman");
        prjc.setCode("ULTRAMAN");
        prjc.setGroupInfo("com.xforceplus");
        prjc.setRemark("ultraman is a platform");
        prjc.setVersion("0.0.1");
        mpg.setProjectConfig(prjc);

        // 应用配置
        ApplicationConfig appc = new ApplicationConfig();
        appc.setName("dto-test");
        appc.setAlias("dtotest");
        appc.setCode("dtotest");
        appc.setRemark("Bocp is a low code platform");
        appc.setVersion("0.0.1");
        appc.setUrl("https://xxx.gitlab.com/digital");
        ModuleInfo mdi = new ModuleInfo();
        mdi.setName("dtotest");
        mdi.setAlias("dtotest");
        List<ModuleInfo> mdiList = new ArrayList<>();
        mdiList.add(mdi);
        appc.setModuleList(mdiList);
        mpg.setApplicationConfig(appc);

        //模块配置
        ModuleConfig mdc = new ModuleConfig();
        mdc.setName("dtotest");
        mdc.setAlias("dtotest");
        mdc.setCode("dtotest");
        mdc.setModuleType("sys");
        mdc.setVersion("0.0.1");
        mpg.setModuleConfig(mdc);

        // 包配置
        PackageConfig pc = new PackageConfig();
        pc.setModuleName("dtotest");
        pc.setParent("com.xforceplus");
        mpg.setPackageInfo(pc);

        DtoConfig dtoConfig = new DtoConfig();
        List<DtoGenInfo> dtoGenInfos = new ArrayList<>();
        DtoGenInfo dtoGenInfo = new DtoGenInfo();
        dtoGenInfo.setName("我的DTO");
        dtoGenInfo.setCode("Mydto");
        List<DtoGenField> dtoGenFields = new ArrayList<>();
        DtoGenField dtoGenField = new DtoGenField();
        dtoGenField.setName("名字");
        dtoGenField.setCode("name");
        dtoGenField.setCapitalCode("Name");
        dtoGenField.setType("String");
        dtoGenField.setRequired(true);
        DtoGenField dtoGenField1 = new DtoGenField();
        dtoGenField1.setName("代码");
        dtoGenField1.setCode("code");
        dtoGenField1.setCapitalCode("Code");
        dtoGenField1.setType("String");
        dtoGenField1.setRequired(false);
        DtoGenField dtoGenField2 = new DtoGenField();
        dtoGenField2.setName("颜色s");
        dtoGenField2.setCode("colors");
        dtoGenField2.setCapitalCode("Colors");
        dtoGenField2.setType("String");
        dtoGenField2.setArray(true);
        dtoGenField2.setRequired(false);
        dtoGenFields.add(dtoGenField);
        dtoGenFields.add(dtoGenField1);
        dtoGenFields.add(dtoGenField2);
        dtoGenInfo.setDtoGenFields(dtoGenFields);
        dtoGenInfos.add(dtoGenInfo);
        dtoConfig.setDtoGenInfos(dtoGenInfos);
        mpg.setDtoConfig(dtoConfig);

        // 策略配置
        StrategyConfig strategy = new StrategyConfig();
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setEntityLombokModel(true);
        strategy.setControllerMappingHyphenStyle(true);
        strategy.setTablePrefix(pc.getModuleName() + "_");
        strategy.setSuperMapperClass(CodeGenConstant.SUPER_MAPPER_CLASS);
        NameConvert nameConvert = new NameConvert();
        strategy.setNameConvert(nameConvert);
        mpg.setStrategy(strategy);
        mpg.setEngineType("dto");
        mpg.execute();

    }

}
