package com.xforceplus.ultraman.bocp.gen.util;

import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.xforceplus.ultraman.bocp.gen.config.ApplicationConfig;
import com.xforceplus.ultraman.bocp.gen.config.ModuleConfig;
import com.xforceplus.ultraman.bocp.gen.config.ProjectConfig;
import com.xforceplus.ultraman.bocp.gen.constant.CodeGenConstant;
import com.xforceplus.ultraman.bocp.gen.generator.BocpAutoGenerator;
import com.xforceplus.ultraman.bocp.gen.po.ModuleInfo;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * mysql 代码生成器演示例子
 * </p>
 *
 * @author wangzheng
 * @since 2019-11-19
 */
public class ModuleGenerator {

    /**
     * RUN THIS
     */
    public static void main(String[] args) {
        excuteBOCP();
//        excutePFCP();
    }

    public static void excuteBOCP(){

        // 代码生成器
        BocpAutoGenerator mpg = new BocpAutoGenerator();
        // 全局配置
        GlobalConfig gc = new GlobalConfig();
//        String projectPath = System.getProperty("user.dir");
//        gc.setOutputDir(projectPath);
        gc.setAuthor("wangzheng");
        gc.setBaseResultMap(true);
        gc.setOpen(false);
        mpg.setGlobalConfig(gc);

        // 数据源配置
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setUrl("jdbc:mysql://120.55.249.44:27306/bocp?useUnicode=true&serverTimezone=GMT&useSSL=false&characterEncoding=utf8");
        // dsc.setSchemaName("public");
        dsc.setDriverName("com.mysql.jdbc.Driver");
        dsc.setUsername("root");
        dsc.setPassword("xplat");
        mpg.setDataSource(dsc);

//        DataSourceConfig dsc = new DataSourceConfig();
//        dsc.setUrl("jdbc:mysql://localhost:3306/pfcp?useUnicode=true&serverTimezone=GMT&useSSL=false&characterEncoding=utf8");
//        // dsc.setSchemaName("public");
//        dsc.setDriverName("com.mysql.jdbc.Driver");
//        dsc.setUsername("root");
//        dsc.setPassword("FGlai123");
//        mpg.setDataSource(dsc);

        // 项目配置
        ProjectConfig prjc = new ProjectConfig();
        prjc.setName("ultraman");
        prjc.setCode("ULTRAMAN");
        prjc.setGroupInfo("com.xforceplus");
        prjc.setRemark("ultraman is a platform");
        prjc.setVersion("0.0.1");
        mpg.setProjectConfig(prjc);

        // 应用配置
        ApplicationConfig appc = new ApplicationConfig();
        appc.setName("ultraman-bocp");
        appc.setAlias("Bocp");
        appc.setCode("BOCP");
        appc.setRemark("Bocp is a low code platform");
        appc.setVersion("0.1.14");
        appc.setUrl("https://xxx.gitlab.com/digital");
        ModuleInfo mdi = new ModuleInfo();
        mdi.setName("ultraman-bocp-metadata");
        mdi.setAlias("Metadata");
//        appc.setName("ultraman-pfcp");
//        appc.setAlias("Pfcp");
//        appc.setCode("PFCP");
//        appc.setRemark("PFCP is a low code platform");
//        appc.setVersion("0.1.14");
//        appc.setUrl("https://xxx.gitlab.com/digital");
//        ModuleInfo mdi = new ModuleInfo();
//        mdi.setName("ultraman-pfcp-setting");
//        mdi.setAlias("Setting");
        List<ModuleInfo> mdiList = new ArrayList<>();
        mdiList.add(mdi);
        appc.setModuleList(mdiList);
        mpg.setApplicationConfig(appc);

        //模块配置
        ModuleConfig mdc = new ModuleConfig();
        mdc.setName("ultraman-bocp-metadata");
        mdc.setAlias("Metadata");
        mdc.setCode("METADATA");
        mdc.setModuleType("sys");
        mdc.setVersion("0.1.14");
        mpg.setModuleConfig(mdc);

//        ModuleConfig mdc = new ModuleConfig();
//        mdc.setName("ultraman-pfcp-setting");
//        mdc.setAlias("Setting");
//        mdc.setCode("SETTING");
//        mdc.setModuleType("sys");
//        mdc.setVersion("0.1.14");
//        mpg.setModuleConfig(mdc);

        // 包配置
        PackageConfig pc = new PackageConfig();
        pc.setModuleName("metadata");
        pc.setParent("com.xforceplus.ultraman.bocp");

//        pc.setModuleName("setting");
//        pc.setParent("com.xforceplus.ultraman.pfcp");
        mpg.setPackageInfo(pc);

        // 策略配置
        StrategyConfig strategy = new StrategyConfig();
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setEntityLombokModel(true);
        strategy.setControllerMappingHyphenStyle(true);
        strategy.setTablePrefix(pc.getModuleName() + "_");
        strategy.setSuperMapperClass(CodeGenConstant.SUPER_MAPPER_CLASS);
        mpg.setStrategy(strategy);
        mpg.setEngineType("mo");
        mpg.execute();
    };

    public static void excutePFCP(){
        // 代码生成器
        BocpAutoGenerator mpg = new BocpAutoGenerator();
        // 全局配置
        GlobalConfig gc = new GlobalConfig();
//        String projectPath = System.getProperty("user.dir");
//        gc.setOutputDir(projectPath);
        gc.setAuthor("wangzheng");
        gc.setBaseResultMap(true);
        gc.setOpen(false);
        mpg.setGlobalConfig(gc);

        // 数据源配置
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setUrl("jdbc:mysql://120.55.249.44:27306/pfcp?useUnicode=true&serverTimezone=GMT&useSSL=false&characterEncoding=utf8");
        // dsc.setSchemaName("public");
        dsc.setDriverName("com.mysql.jdbc.Driver");
        dsc.setUsername("root");
        dsc.setPassword("xplat");
        mpg.setDataSource(dsc);

        // 项目配置
        ProjectConfig prjc = new ProjectConfig();
        prjc.setName("ultraman");
        prjc.setCode("ULTRAMAN");
        prjc.setGroupInfo("com.xforceplus");
        prjc.setRemark("ultraman is a platform");
        prjc.setVersion("0.0.1");
        mpg.setProjectConfig(prjc);

        // 应用配置
        ApplicationConfig appc = new ApplicationConfig();
        appc.setName("ultraman-pfcp");
        appc.setAlias("Pfcp");
        appc.setCode("PFCP");
        appc.setRemark("PFCP is a low code platform");
        appc.setVersion("0.1.5");
        appc.setUrl("https://xxx.gitlab.com/digital");
        ModuleInfo mdi = new ModuleInfo();
        mdi.setName("ultraman-pfcp-setting");
        mdi.setAlias("Setting");
        List<ModuleInfo> mdiList = new ArrayList<>();
        mdiList.add(mdi);
        appc.setModuleList(mdiList);
        mpg.setApplicationConfig(appc);

        //模块配置
        ModuleConfig mdc = new ModuleConfig();
        mdc.setName("ultraman-pfcp-setting");
        mdc.setAlias("Setting");
        mdc.setCode("SETTING");
        mdc.setModuleType("sys");
        mdc.setVersion("0.1.5");
        mpg.setModuleConfig(mdc);

        // 包配置
        PackageConfig pc = new PackageConfig();
        pc.setModuleName("setting");
        pc.setParent("com.xforceplus.ultraman.pfcp");
        mpg.setPackageInfo(pc);

        // 策略配置
        StrategyConfig strategy = new StrategyConfig();
        strategy.setNaming(NamingStrategy.underline_to_camel);
        strategy.setColumnNaming(NamingStrategy.underline_to_camel);
        strategy.setEntityLombokModel(true);
        strategy.setControllerMappingHyphenStyle(true);
        strategy.setTablePrefix(pc.getModuleName() + "_");
        strategy.setSuperMapperClass(CodeGenConstant.SUPER_MAPPER_CLASS);
        mpg.setStrategy(strategy);
        mpg.setEngineType("mo");
        mpg.execute();
    };

}
