import Mock from 'mockjs';
import { FIELD_TYPE } from './consts';

const Random = Mock.Random;

let enumValues = {};

export default function mockEnumValues(setting) {
  enumValues = {};
  setting.fields.forEach((field) => {
    setEnumValues(field);
  });
  setting.subEntities.forEach((subEntity) => {
    subEntity.fields.forEach((field) => {
      setEnumValues(field);
    });
  });

  function setEnumValues(field) {
    if (field.type === FIELD_TYPE.ENUM.code && enumValues[field.enumCode] === undefined) {
      setEnumValuesByCode(field.enumCode);
    }
    if (field.type === FIELD_TYPE.RELATIONSHIP.code) {
      field.relationshipEntity.fields.forEach((field) => {
        if (field.type === FIELD_TYPE.ENUM.code && enumValues[field.enumCode] === undefined) {
          setEnumValuesByCode(field.enumCode);
        }
      });
    }
  }
  // 随机生成3~10个枚举项
  function setEnumValuesByCode(enumCode) {
    const len = Random.natural(3, 10);
    let value = 0;
    enumValues[enumCode] = new Array(len).fill(null).map(() => {
      const enumValue = value++;
      const text = /rate$/.test(enumCode.toLowerCase()) ? `${enumValue}%` : Random.string(4, 10);
      return {
        value: enumValue,
        text,
      };
    });
  }
  return enumValues;
}
