/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.gen.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.IDbQuery;
import com.baomidou.mybatisplus.generator.config.INameConvert;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.config.rules.NamingStrategy;
import com.xforceplus.ultraman.bocp.gen.config.ApplicationConfig;
import com.xforceplus.ultraman.bocp.gen.config.BoConfig;
import com.xforceplus.ultraman.bocp.gen.config.BocpTemplateConfig;
import com.xforceplus.ultraman.bocp.gen.config.DictConfig;
import com.xforceplus.ultraman.bocp.gen.config.DtoConfig;
import com.xforceplus.ultraman.bocp.gen.config.ModuleConfig;
import com.xforceplus.ultraman.bocp.gen.config.ProjectConfig;
import com.xforceplus.ultraman.bocp.gen.po.BoGenField;
import com.xforceplus.ultraman.bocp.gen.po.BoGenInfo;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class BocpConfigBuilder {
    private ProjectConfig projectConfig;
    private ApplicationConfig applicationConfig;
    private ModuleConfig moduleConfig;
    private BoConfig boConfig;
    private DictConfig dictConfig;
    private DtoConfig dtoConfig;
    private BocpTemplateConfig bocpTemplate;
    private DataSourceConfig dataSourceConfig;
    private Connection connection;
    private IDbQuery dbQuery;
    private String superEntityClass;
    private String superMapperClass;
    private TableInfo baseEntity;
    private String superServiceClass;
    private String superServiceImplClass;
    private String superControllerClass;
    private List<TableInfo> tableInfoList;
    private Map<String, String> packageInfo;
    private Map<String, String> pathInfo;
    private StrategyConfig strategyConfig;
    private GlobalConfig globalConfig;
    private InjectionConfig injectionConfig;
    private boolean commentSupported;

    public BocpConfigBuilder(ProjectConfig projectConfig, ApplicationConfig applicationConfig, ModuleConfig moduleConfig, BoConfig boConfig, DictConfig dictConfig, DtoConfig dtoConfig, PackageConfig packageConfig, DataSourceConfig dataSourceConfig, StrategyConfig strategyConfig, BocpTemplateConfig bocpTemplate, GlobalConfig globalConfig) {
        if (null != projectConfig) {
            this.projectConfig = projectConfig;
        }
        if (null != applicationConfig) {
            this.applicationConfig = applicationConfig;
        }
        if (null != moduleConfig) {
            this.moduleConfig = moduleConfig;
        }
        if (null != boConfig) {
            this.boConfig = boConfig;
        }
        if (null != dictConfig) {
            this.dictConfig = dictConfig;
        }
        this.dtoConfig = dtoConfig;
        this.globalConfig = null == globalConfig ? new GlobalConfig() : globalConfig;
        this.bocpTemplate = null == bocpTemplate ? new BocpTemplateConfig() : bocpTemplate;
        if (null == packageConfig) {
            this.handlerPackage(this.bocpTemplate, this.globalConfig.getOutputDir(), new PackageConfig());
        } else {
            this.handlerPackage(this.bocpTemplate, this.globalConfig.getOutputDir(), packageConfig);
        }
        this.strategyConfig = null == strategyConfig ? new StrategyConfig() : strategyConfig;
        this.dataSourceConfig = dataSourceConfig;
        if (null != boConfig) {
            if (boConfig.getFromDB().booleanValue() && this.dataSourceConfig != null) {
                this.handlerDataSource(dataSourceConfig);
                this.commentSupported = !dataSourceConfig.getDbType().equals((Object)DbType.SQLITE);
                this.handlerStrategy(this.strategyConfig);
            } else {
                this.handlerStrategyByBo(this.strategyConfig, boConfig);
            }
        }
    }

    public Map<String, String> getPackageInfo() {
        return this.packageInfo;
    }

    public Map<String, String> getPathInfo() {
        return this.pathInfo;
    }

    public String getSuperEntityClass() {
        return this.superEntityClass;
    }

    public String getSuperMapperClass() {
        return this.superMapperClass;
    }

    public String getSuperServiceClass() {
        return this.superServiceClass;
    }

    public String getSuperServiceImplClass() {
        return this.superServiceImplClass;
    }

    public String getSuperControllerClass() {
        return this.superControllerClass;
    }

    public List<TableInfo> getTableInfoList() {
        return this.tableInfoList;
    }

    public BocpConfigBuilder setTableInfoList(List<TableInfo> tableInfoList) {
        this.tableInfoList = tableInfoList;
        return this;
    }

    public BocpTemplateConfig getBocpTemplate() {
        return this.bocpTemplate == null ? new BocpTemplateConfig() : this.bocpTemplate;
    }

    private void handlerPackage(BocpTemplateConfig bocpTemplate, String outputDir, PackageConfig config) {
        Map configPathInfo;
        String projectPath = this.joinPackage(null, this.projectConfig.getName());
        String applicationPath = this.joinPackage(projectPath, this.applicationConfig.getName());
        String applicationServicePath = this.joinPackage(applicationPath, this.applicationConfig.getName() + "-service");
        String applicationClientPath = this.joinPackage(applicationPath, this.applicationConfig.getName() + "-client");
        String applicationClientMainPath = this.joinPackage(applicationServicePath, "src.main.java");
        String applicationClientResourcesPath = this.joinPackage(applicationClientPath, "src.main.resources");
        String applicationClientPackegePath = this.joinPackage(applicationClientMainPath, config.getParent());
        String applicationServiceMainPath = this.joinPackage(applicationServicePath, "src.main.java");
        String applicationServiceResourcesPath = this.joinPackage(applicationServicePath, "src.main.resources");
        String applicationServicePackegePath = this.joinPackage(applicationServiceMainPath, config.getParent());
        String modulePath = this.joinPackage(projectPath, this.moduleConfig.getName());
        String moduleServicePath = this.joinPackage(modulePath, this.moduleConfig.getName() + "-service");
        String moduleClientPath = this.joinPackage(modulePath, this.moduleConfig.getName() + "-client");
        String moduleDomainPath = this.joinPackage(modulePath, this.moduleConfig.getName() + "-domain");
        String moduleClientMainPath = this.joinPackage(moduleClientPath, "src.main.java");
        String moduleClientResourcesPath = this.joinPackage(moduleClientPath, "src.main.resources");
        String moduleClientPackegePath = this.joinPackage(moduleClientMainPath, config.getParent());
        String moduleServiceMainPath = this.joinPackage(moduleServicePath, "src.main.java");
        String moduleServiceResourcesPath = this.joinPackage(moduleServicePath, "src.main.resources");
        String moduleServicePackegePath = this.joinPackage(moduleServiceMainPath, config.getParent());
        String moduleDomainMainPath = this.joinPackage(moduleDomainPath, "src.main.java");
        String moduleDomainResourcesPath = this.joinPackage(moduleDomainMainPath, "src.main.resources");
        String moduleDomainPackegePath = this.joinPackage(moduleDomainMainPath, config.getParent());
        this.packageInfo = new HashMap<String, String>(8);
        if (null != this.boConfig) {
            this.packageInfo.put("ModuleName", config.getModuleName());
            this.packageInfo.put("Entity", this.joinPackage(moduleDomainPackegePath, config.getEntity()));
            this.packageInfo.put("Mapper", this.joinPackage(moduleServicePackegePath, config.getMapper()));
            this.packageInfo.put("Xml", this.joinPackage(moduleServiceResourcesPath, config.getXml()));
            this.packageInfo.put("Service", this.joinPackage(moduleServicePackegePath, config.getService()));
            this.packageInfo.put("ServiceImpl", this.joinPackage(moduleServicePackegePath, config.getServiceImpl()));
            this.packageInfo.put("Controller", this.joinPackage(moduleServicePackegePath, config.getController()));
            this.packageInfo.put("Feign", this.joinPackage(moduleClientPackegePath, config.getController()));
            this.packageInfo.put("EntityPackege", this.joinPackage(config.getParent(), config.getEntity()));
            this.packageInfo.put("MapperPackege", this.joinPackage(config.getParent(), config.getMapper()));
            this.packageInfo.put("XmlPackege", this.joinPackage(config.getParent(), config.getXml()));
            this.packageInfo.put("ServicePackege", this.joinPackage(config.getParent(), config.getService()));
            this.packageInfo.put("ServiceImplPackege", this.joinPackage(config.getParent(), config.getServiceImpl()));
            this.packageInfo.put("ControllerPackege", this.joinPackage(config.getParent(), config.getController()));
            this.packageInfo.put("FeignPackege", this.joinPackage(config.getParent(), config.getController()));
            this.packageInfo.put("BaseEntity", this.joinPackage(moduleDomainPackegePath, config.getEntity()));
        }
        if (this.dictConfig != null) {
            this.packageInfo.put("Enum", this.joinPackage(moduleDomainPackegePath, "dict"));
            this.packageInfo.put("DictPackage", this.joinPackage(config.getParent(), "dict"));
        }
        if (this.dtoConfig != null) {
            this.packageInfo.put("Dto", this.joinPackage(moduleDomainPackegePath, "dto"));
            this.packageInfo.put("DtoPackage", this.joinPackage(config.getParent(), "dto"));
        }
        if (null != this.applicationConfig.getName()) {
            this.packageInfo.put("Project", projectPath);
            this.packageInfo.put("Application", applicationPath);
            this.packageInfo.put("ApplicationService", applicationServicePath);
            this.packageInfo.put("ApplicationServicePackage", config.getParent());
            this.packageInfo.put("appApplicationYml", applicationServiceResourcesPath);
            this.packageInfo.put("appApplicationService", applicationServicePackegePath);
            this.packageInfo.put("appApplicationTests", applicationServicePackegePath);
        }
        if (null != this.moduleConfig.getName()) {
            this.packageInfo.put("Module", modulePath);
            this.packageInfo.put("ModuleClient", moduleClientPath);
            this.packageInfo.put("ModuleService", moduleServicePath);
            this.packageInfo.put("ModuleDomain", moduleDomainPath);
            this.packageInfo.put("ModuleServicePackage", config.getParent());
            this.packageInfo.put("moduleApplicationYml", moduleServiceResourcesPath);
            this.packageInfo.put("moduleApplicationService", moduleServicePackegePath);
        }
        if (null != (configPathInfo = config.getPathInfo())) {
            this.pathInfo = configPathInfo;
        } else {
            this.pathInfo = new HashMap<String, String>(6);
            if (null != this.boConfig) {
                this.setPathInfo(this.pathInfo, bocpTemplate.getEntity(this.getGlobalConfig().isKotlin()), outputDir, "entity_path", "Entity");
                this.setPathInfo(this.pathInfo, bocpTemplate.getMapper(), outputDir, "mapper_path", "Mapper");
                this.setPathInfo(this.pathInfo, bocpTemplate.getXml(), outputDir, "xml_path", "Xml");
                this.setPathInfo(this.pathInfo, bocpTemplate.getService(), outputDir, "service_path", "Service");
                this.setPathInfo(this.pathInfo, bocpTemplate.getServiceImpl(), outputDir, "service_impl_path", "ServiceImpl");
                this.setPathInfo(this.pathInfo, bocpTemplate.getController(), outputDir, "controller_path", "Controller");
                this.setPathInfo(this.pathInfo, bocpTemplate.getFeign(), outputDir, "feign_path", "Feign");
                this.setPathInfo(this.pathInfo, bocpTemplate.getBaseEntity(this.getGlobalConfig().isKotlin()), outputDir, "base_entity_path", "BaseEntity");
            }
            if (null != this.dictConfig) {
                this.setPathInfo(this.pathInfo, bocpTemplate.getEnum(this.getGlobalConfig().isKotlin()), outputDir, "enum_path", "Enum");
            }
            if (null != this.dtoConfig) {
                this.setPathInfo(this.pathInfo, bocpTemplate.getDto(this.getGlobalConfig().isKotlin()), outputDir, "dto_path", "Dto");
            }
            if (null != this.applicationConfig.getName()) {
                this.setPathInfo(this.pathInfo, bocpTemplate.getApplicationParentPom(), outputDir, "parent_pom_path", "Project");
                this.setPathInfo(this.pathInfo, bocpTemplate.getGitignore(), outputDir, "gitignore_path", "Application");
                this.setPathInfo(this.pathInfo, bocpTemplate.getGitlab(), outputDir, "gitlab_path", "Application");
                this.setPathInfo(this.pathInfo, bocpTemplate.getApplicationPom(), outputDir, "pom_path", "Application");
                this.setPathInfo(this.pathInfo, bocpTemplate.getApplicationYml(), outputDir, "application_yml_path", "appApplicationYml");
                this.setPathInfo(this.pathInfo, bocpTemplate.getServicePom(), outputDir, "service_pom_path", "ApplicationService");
                this.setPathInfo(this.pathInfo, bocpTemplate.getServiceApplication(), outputDir, "service_application_path", "appApplicationService");
                this.setPathInfo(this.pathInfo, bocpTemplate.getServiceApplicationTest(), outputDir, "service_application_test_path", "appApplicationTests");
            }
            if (null != this.moduleConfig.getName()) {
                this.setPathInfo(this.pathInfo, bocpTemplate.getModuleParentPom(), outputDir, "module_parent_pom_path", "Project");
                this.setPathInfo(this.pathInfo, bocpTemplate.getModuleGitignore(), outputDir, "module_gitignore_path", "Module");
                this.setPathInfo(this.pathInfo, bocpTemplate.getModuleGitlab(), outputDir, "module_gitlab_path", "Module");
                this.setPathInfo(this.pathInfo, bocpTemplate.getModulePom(), outputDir, "module_pom_path", "Module");
                this.setPathInfo(this.pathInfo, bocpTemplate.getModuleClientPom(), outputDir, "module_client_pom_path", "ModuleClient");
                this.setPathInfo(this.pathInfo, bocpTemplate.getModuleApplicationYml(), outputDir, "module_application_yml_path", "moduleApplicationYml");
                this.setPathInfo(this.pathInfo, bocpTemplate.getModuleServicePom(), outputDir, "module_service_pom_path", "ModuleService");
                this.setPathInfo(this.pathInfo, bocpTemplate.getModuleServicePom(), outputDir, "module_domain_pom_path", "ModuleDomain");
                this.setPathInfo(this.pathInfo, bocpTemplate.getModuleServiceApplication(), outputDir, "module_service_application_path", "moduleApplicationService");
            }
        }
    }

    private void setPathInfo(Map<String, String> pathInfo, String bocpTemplate, String outputDir, String path, String module) {
        if (StringUtils.isNotEmpty((CharSequence)bocpTemplate)) {
            pathInfo.put(path, this.joinPath(outputDir, this.packageInfo.get(module)));
        }
    }

    private void handlerDataSource(DataSourceConfig config) {
        this.connection = config.getConn();
        this.dbQuery = config.getDbQuery();
    }

    private void handlerStrategy(StrategyConfig config) {
        this.processTypes(config);
        this.tableInfoList = this.getTablesInfo(config);
    }

    private void handlerStrategyByBo(StrategyConfig config, BoConfig boConfig) {
        this.processTypes(config);
        this.tableInfoList = this.getTablesInfoByBo(config, boConfig);
        if (boConfig.getBaseEntity() != null) {
            this.baseEntity = this.buildTableInfo(config, boConfig.getBaseEntity());
            this.nameConvert(this.baseEntity, config.getNaming(), config.getTablePrefix());
        }
    }

    private void processTypes(StrategyConfig config) {
        this.superServiceClass = StringUtils.isEmpty((CharSequence)config.getSuperServiceClass()) ? "com.baomidou.mybatisplus.extension.service.IService" : config.getSuperServiceClass();
        this.superServiceImplClass = StringUtils.isEmpty((CharSequence)config.getSuperServiceImplClass()) ? "com.baomidou.mybatisplus.extension.service.impl.ServiceImpl" : config.getSuperServiceImplClass();
        this.superMapperClass = StringUtils.isEmpty((CharSequence)config.getSuperMapperClass()) ? "com.baomidou.mybatisplus.core.mapper.BaseMapper" : config.getSuperMapperClass();
        this.superEntityClass = config.getSuperEntityClass();
        this.superControllerClass = config.getSuperControllerClass();
    }

    private List<TableInfo> processTable(List<TableInfo> tableList, NamingStrategy strategy, StrategyConfig config) {
        String[] tablePrefix = config.getTablePrefix();
        for (TableInfo tableInfo : tableList) {
            this.nameConvert(tableInfo, strategy, tablePrefix);
            this.checkImportPackages(tableInfo);
        }
        return tableList;
    }

    private void nameConvert(TableInfo tableInfo, NamingStrategy strategy, String[] tablePrefix) {
        INameConvert nameConvert = this.strategyConfig.getNameConvert();
        String entityName = null != nameConvert ? NamingStrategy.capitalFirst((String)this.processName(nameConvert.entityNameConvert(tableInfo), strategy, tablePrefix)) : NamingStrategy.capitalFirst((String)this.processName(tableInfo.getName(), strategy, tablePrefix));
        if (StringUtils.isNotEmpty((CharSequence)this.globalConfig.getEntityName())) {
            tableInfo.setConvert(true);
            tableInfo.setEntityName(String.format(this.globalConfig.getEntityName(), entityName));
        } else {
            tableInfo.setEntityName(this.strategyConfig, entityName);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.globalConfig.getMapperName())) {
            tableInfo.setMapperName(String.format(this.globalConfig.getMapperName(), entityName));
        } else {
            tableInfo.setMapperName(entityName + "Mapper");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.globalConfig.getXmlName())) {
            tableInfo.setXmlName(String.format(this.globalConfig.getXmlName(), entityName));
        } else {
            tableInfo.setXmlName(entityName + "Mapper");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.globalConfig.getServiceName())) {
            tableInfo.setServiceName(String.format(this.globalConfig.getServiceName(), entityName));
        } else {
            tableInfo.setServiceName("I" + entityName + "Service");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.globalConfig.getServiceImplName())) {
            tableInfo.setServiceImplName(String.format(this.globalConfig.getServiceImplName(), entityName));
        } else {
            tableInfo.setServiceImplName(entityName + "ServiceImpl");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.globalConfig.getControllerName())) {
            tableInfo.setControllerName(String.format(this.globalConfig.getControllerName(), entityName));
        } else {
            tableInfo.setControllerName(entityName + "Controller");
        }
    }

    private void checkImportPackages(TableInfo tableInfo) {
        if (StringUtils.isNotEmpty((CharSequence)this.strategyConfig.getSuperEntityClass())) {
            tableInfo.getImportPackages().add(this.strategyConfig.getSuperEntityClass());
        } else if (this.globalConfig.isActiveRecord()) {
            tableInfo.getImportPackages().add(Model.class.getCanonicalName());
        }
        if (null != this.globalConfig.getIdType()) {
            tableInfo.getImportPackages().add(IdType.class.getCanonicalName());
            tableInfo.getImportPackages().add(TableId.class.getCanonicalName());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.strategyConfig.getVersionFieldName())) {
            tableInfo.getFields().forEach(f -> {
                if (this.strategyConfig.getVersionFieldName().equals(f.getName())) {
                    tableInfo.getImportPackages().add(Version.class.getCanonicalName());
                }
            });
        }
    }

    private List<TableInfo> getTablesInfoByBo(StrategyConfig config, BoConfig boConfig) {
        boolean isExclude;
        if (boConfig.getBoGenInfoList() == null) {
            return new ArrayList<TableInfo>();
        }
        boolean isInclude = null != config.getInclude() && config.getInclude().length > 0;
        boolean bl = isExclude = null != config.getExclude() && config.getExclude().length > 0;
        if (isInclude && isExclude) {
            throw new RuntimeException("<strategy> \u6807\u7b7e\u4e2d <include> \u4e0e <exclude> \u53ea\u80fd\u914d\u7f6e\u4e00\u9879\uff01");
        }
        ArrayList<TableInfo> tableList = new ArrayList<TableInfo>();
        ArrayList includeTableList = new ArrayList();
        ArrayList excludeTableList = new ArrayList();
        HashSet notExistTables = new HashSet();
        for (BoGenInfo bo : boConfig.getBoGenInfoList()) {
            TableInfo tableInfo = this.buildTableInfo(config, bo);
            tableList.add(tableInfo);
        }
        return this.processTable(tableList, config.getNaming(), config);
    }

    private TableInfo buildTableInfo(StrategyConfig config, BoGenInfo bo) {
        TableInfo tableInfo = new TableInfo();
        tableInfo.setName(bo.getName());
        tableInfo.setComment(bo.getRemark());
        ArrayList<TableField> fieldList = new ArrayList<TableField>();
        ArrayList<TableField> commonFieldList = new ArrayList<TableField>();
        for (BoGenField boGenField : bo.getBoGenFieldList()) {
            TableField field = new TableField();
            String columnName = boGenField.getName();
            if (boGenField.getFieldKey() != null && "1".equals(boGenField.getFieldKey())) {
                field.setKeyIdentityFlag(true);
            } else {
                field.setKeyFlag(false);
            }
            field.setName(columnName);
            field.setType(boGenField.getFiledType());
            INameConvert nameConvert = this.strategyConfig.getNameConvert();
            if (null != nameConvert) {
                field.setPropertyName(this.strategyConfig, this.processName(nameConvert.propertyNameConvert(field), config.getNaming()));
            } else {
                field.setPropertyName(this.strategyConfig, this.processName(field.getName(), config.getNaming()));
            }
            if (null != this.dataSourceConfig) {
                field.setColumnType(this.dataSourceConfig.getTypeConvert().processTypeConvert(this.globalConfig, field));
            }
            if (this.commentSupported) {
                field.setComment(boGenField.getRemark());
            }
            if ("entity".equals(bo.getBoType()) && this.strategyConfig.includeSuperEntityColumns(field.getName())) {
                commonFieldList.add(field);
                continue;
            }
            List tableFillList = this.getStrategyConfig().getTableFillList();
            if (null != tableFillList) {
                tableFillList.stream().filter(tf -> tf.getFieldName().equalsIgnoreCase(field.getName())).findFirst().ifPresent(tf -> field.setFill(tf.getFieldFill().name()));
            }
            fieldList.add(field);
        }
        tableInfo.setFields(fieldList);
        tableInfo.setCommonFields(commonFieldList);
        return tableInfo;
    }

    private List<TableInfo> getTablesInfo(StrategyConfig config) {
        boolean isExclude;
        boolean isInclude = null != config.getInclude() && config.getInclude().length > 0;
        boolean bl = isExclude = null != config.getExclude() && config.getExclude().length > 0;
        if (isInclude && isExclude) {
            throw new RuntimeException("<strategy> \u6807\u7b7e\u4e2d <include> \u4e0e <exclude> \u53ea\u80fd\u914d\u7f6e\u4e00\u9879\uff01");
        }
        ArrayList<TableInfo> tableList = new ArrayList<TableInfo>();
        ArrayList<Object> includeTableList = new ArrayList<TableInfo>();
        ArrayList<TableInfo> excludeTableList = new ArrayList<TableInfo>();
        HashSet<String> notExistTables = new HashSet<String>();
        try {
            String schema;
            String tablesSql = this.dbQuery.tablesSql();
            if (DbType.POSTGRE_SQL == this.dbQuery.dbType()) {
                schema = this.dataSourceConfig.getSchemaName();
                if (schema == null) {
                    schema = "public";
                    this.dataSourceConfig.setSchemaName(schema);
                }
                tablesSql = String.format(tablesSql, schema);
            }
            if (DbType.DB2 == this.dbQuery.dbType()) {
                schema = this.dataSourceConfig.getSchemaName();
                if (schema == null) {
                    schema = "current schema";
                    this.dataSourceConfig.setSchemaName(schema);
                }
                tablesSql = String.format(tablesSql, schema);
            } else if (DbType.ORACLE == this.dbQuery.dbType()) {
                StringBuilder sb;
                schema = this.dataSourceConfig.getSchemaName();
                if (schema == null) {
                    schema = this.dataSourceConfig.getUsername().toUpperCase();
                    this.dataSourceConfig.setSchemaName(schema);
                }
                tablesSql = String.format(tablesSql, schema);
                if (isInclude) {
                    sb = new StringBuilder(tablesSql);
                    sb.append(" AND ").append(this.dbQuery.tableName()).append(" IN (");
                    Arrays.stream(config.getInclude()).forEach(tbname -> sb.append("'").append(tbname.toUpperCase()).append("',"));
                    sb.replace(sb.length() - 1, sb.length(), ")");
                    tablesSql = sb.toString();
                } else if (isExclude) {
                    sb = new StringBuilder(tablesSql);
                    sb.append(" AND ").append(this.dbQuery.tableName()).append(" NOT IN (");
                    Arrays.stream(config.getExclude()).forEach(tbname -> sb.append("'").append(tbname.toUpperCase()).append("',"));
                    sb.replace(sb.length() - 1, sb.length(), ")");
                    tablesSql = sb.toString();
                }
            }
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(tablesSql);
                 ResultSet results = preparedStatement.executeQuery();){
                while (results.next()) {
                    String tableName = results.getString(this.dbQuery.tableName());
                    if (StringUtils.isNotEmpty((CharSequence)tableName)) {
                        TableInfo tableInfo = new TableInfo();
                        tableInfo.setName(tableName);
                        if (this.commentSupported) {
                            String tableComment = results.getString(this.dbQuery.tableComment());
                            if (config.isSkipView() && "VIEW".equals(tableComment)) continue;
                            tableInfo.setComment(tableComment);
                        }
                        if (isInclude) {
                            for (String includeTable : config.getInclude()) {
                                if (this.tableNameMatches(includeTable, tableName)) {
                                    includeTableList.add(tableInfo);
                                    continue;
                                }
                                notExistTables.add(includeTable);
                            }
                        } else if (isExclude) {
                            for (String excludeTable : config.getExclude()) {
                                if (this.tableNameMatches(excludeTable, tableName)) {
                                    excludeTableList.add(tableInfo);
                                    continue;
                                }
                                notExistTables.add(excludeTable);
                            }
                        }
                        tableList.add(tableInfo);
                        continue;
                    }
                    System.err.println("\u5f53\u524d\u6570\u636e\u5e93\u4e3a\u7a7a\uff01\uff01\uff01");
                }
            }
            for (TableInfo tabInfo : tableList) {
                notExistTables.remove(tabInfo.getName());
            }
            if (notExistTables.size() > 0) {
                System.err.println("\u8868 " + notExistTables + " \u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\uff01\uff01\uff01");
            }
            if (isExclude) {
                tableList.removeAll(excludeTableList);
                includeTableList = tableList;
            }
            if (!isInclude && !isExclude) {
                includeTableList = tableList;
            }
            includeTableList.forEach(ti -> this.convertTableFields((TableInfo)ti, config));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.processTable(includeTableList, config.getNaming(), config);
    }

    private boolean tableNameMatches(String setTableName, String dbTableName) {
        return setTableName.equalsIgnoreCase(dbTableName) || StringUtils.matches((String)setTableName, (String)dbTableName);
    }

    private TableInfo convertTableFields(TableInfo tableInfo, StrategyConfig config) {
        boolean haveId = false;
        ArrayList<TableField> fieldList = new ArrayList<TableField>();
        ArrayList<TableField> commonFieldList = new ArrayList<TableField>();
        DbType dbType = this.dbQuery.dbType();
        String tableName = tableInfo.getName();
        try {
            Throwable throwable;
            Throwable throwable2;
            String tableFieldsSql = this.dbQuery.tableFieldsSql();
            HashSet<String> h2PkColumns = new HashSet<String>();
            if (DbType.POSTGRE_SQL == dbType) {
                tableFieldsSql = String.format(tableFieldsSql, this.dataSourceConfig.getSchemaName(), tableName);
            } else if (DbType.DB2 == dbType) {
                tableFieldsSql = String.format(tableFieldsSql, this.dataSourceConfig.getSchemaName(), tableName);
            } else if (DbType.ORACLE == dbType) {
                tableName = tableName.toUpperCase();
                tableFieldsSql = String.format(tableFieldsSql.replace("#schema", this.dataSourceConfig.getSchemaName()), tableName);
            } else if (DbType.DM == dbType) {
                tableName = tableName.toUpperCase();
                tableFieldsSql = String.format(tableFieldsSql, tableName);
            } else if (DbType.H2 == dbType) {
                tableName = tableName.toUpperCase();
                throwable2 = null;
                try (PreparedStatement pkQueryStmt = this.connection.prepareStatement(String.format("select * from INFORMATION_SCHEMA.INDEXES WHERE TABLE_NAME = '%s'", tableName));){
                    throwable = null;
                    try (ResultSet pkResults = pkQueryStmt.executeQuery();){
                        while (pkResults.next()) {
                            String primaryKey = pkResults.getString(this.dbQuery.fieldKey());
                            if (!Boolean.valueOf(primaryKey).booleanValue()) continue;
                            h2PkColumns.add(pkResults.getString(this.dbQuery.fieldName()));
                        }
                    }
                    catch (Throwable primaryKey) {
                        throwable = primaryKey;
                        throw primaryKey;
                    }
                }
                catch (Throwable pkResults) {
                    throwable2 = pkResults;
                    throw pkResults;
                }
                tableFieldsSql = String.format(tableFieldsSql, tableName);
            } else {
                tableFieldsSql = String.format(tableFieldsSql, tableName);
            }
            throwable2 = null;
            try (PreparedStatement preparedStatement = this.connection.prepareStatement(tableFieldsSql);){
                throwable = null;
                try (ResultSet results = preparedStatement.executeQuery();){
                    while (results.next()) {
                        boolean isId;
                        TableField field = new TableField();
                        String columnName = results.getString(this.dbQuery.fieldName());
                        if (DbType.H2 == dbType) {
                            isId = h2PkColumns.contains(columnName);
                        } else {
                            String key = results.getString(this.dbQuery.fieldKey());
                            if (DbType.DB2 == dbType || DbType.SQLITE == dbType) {
                                isId = StringUtils.isNotEmpty((CharSequence)key) && "1".equals(key);
                            } else {
                                boolean bl = isId = StringUtils.isNotEmpty((CharSequence)key) && "PRI".equals(key.toUpperCase());
                            }
                        }
                        if (isId && !haveId) {
                            field.setKeyFlag(true);
                            if (DbType.H2 == dbType || DbType.SQLITE == dbType || this.dbQuery.isKeyIdentity(results)) {
                                field.setKeyIdentityFlag(true);
                            }
                            haveId = true;
                        } else {
                            field.setKeyFlag(false);
                        }
                        String[] fcs = this.dbQuery.fieldCustom();
                        if (null != fcs) {
                            HashMap<String, Object> customMap = new HashMap<String, Object>(fcs.length);
                            for (String fc : fcs) {
                                customMap.put(fc, results.getObject(fc));
                            }
                            field.setCustomMap(customMap);
                        }
                        field.setName(columnName);
                        field.setType(results.getString(this.dbQuery.fieldType()));
                        INameConvert nameConvert = this.strategyConfig.getNameConvert();
                        if (null != nameConvert) {
                            field.setPropertyName(this.strategyConfig, this.processName(nameConvert.propertyNameConvert(field), config.getNaming()));
                        } else {
                            field.setPropertyName(this.strategyConfig, this.processName(field.getName(), config.getNaming()));
                        }
                        if (null != this.dataSourceConfig) {
                            field.setColumnType(this.dataSourceConfig.getTypeConvert().processTypeConvert(this.globalConfig, field));
                        }
                        if (this.commentSupported) {
                            field.setComment(results.getString(this.dbQuery.fieldComment()));
                        }
                        if (this.strategyConfig.includeSuperEntityColumns(field.getName())) {
                            commonFieldList.add(field);
                            continue;
                        }
                        List tableFillList = this.getStrategyConfig().getTableFillList();
                        if (null != tableFillList) {
                            tableFillList.stream().filter(tf -> tf.getFieldName().equalsIgnoreCase(field.getName())).findFirst().ifPresent(tf -> field.setFill(tf.getFieldFill().name()));
                        }
                        fieldList.add(field);
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
        }
        catch (SQLException e) {
            System.err.println("SQL Exception\uff1a" + e.getMessage());
        }
        tableInfo.setFields(fieldList);
        tableInfo.setCommonFields(commonFieldList);
        return tableInfo;
    }

    private String joinPath(String parentDir, String packageName) {
        if (StringUtils.isEmpty((CharSequence)parentDir)) {
            parentDir = System.getProperty("java.io.tmpdir");
        }
        if (!StringUtils.endsWith((String)parentDir, (String)File.separator)) {
            parentDir = parentDir + File.separator;
        }
        packageName = packageName.replaceAll("\\.", "\\" + File.separator);
        return parentDir + packageName;
    }

    private String joinPackage(String parent, String subPackage) {
        if (StringUtils.isEmpty((CharSequence)parent)) {
            return subPackage;
        }
        return parent + "." + subPackage;
    }

    private String processName(String name, NamingStrategy strategy) {
        return this.processName(name, strategy, this.strategyConfig.getFieldPrefix());
    }

    private String processName(String name, NamingStrategy strategy, String[] prefix) {
        boolean removePrefix = false;
        if (prefix != null && prefix.length != 0) {
            removePrefix = true;
        }
        String propertyName = removePrefix ? (strategy == NamingStrategy.underline_to_camel ? NamingStrategy.removePrefixAndCamel((String)name, (String[])prefix) : NamingStrategy.removePrefix((String)name, (String[])prefix)) : (strategy == NamingStrategy.underline_to_camel ? NamingStrategy.underlineToCamel((String)name) : name);
        return propertyName;
    }

    public StrategyConfig getStrategyConfig() {
        return this.strategyConfig;
    }

    public BocpConfigBuilder setStrategyConfig(StrategyConfig strategyConfig) {
        this.strategyConfig = strategyConfig;
        return this;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public BocpConfigBuilder setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
        return this;
    }

    public InjectionConfig getInjectionConfig() {
        return this.injectionConfig;
    }

    public BocpConfigBuilder setInjectionConfig(InjectionConfig injectionConfig) {
        this.injectionConfig = injectionConfig;
        return this;
    }

    public ProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    public void setProjectConfig(ProjectConfig projectConfig) {
        this.projectConfig = projectConfig;
    }

    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public void setApplicationConfig(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public ModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    public void setModuleConfig(ModuleConfig moduleConfig) {
        this.moduleConfig = moduleConfig;
    }

    public BoConfig getBoConfig() {
        return this.boConfig;
    }

    public void setBoConfig(BoConfig boConfig) {
        this.boConfig = boConfig;
    }

    public DataSourceConfig getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    public void setDataSourceConfig(DataSourceConfig dataSourceConfig) {
        this.dataSourceConfig = dataSourceConfig;
    }

    public TableInfo getBaseEntity() {
        return this.baseEntity;
    }

    public void setBaseEntity(TableInfo baseEntity) {
        this.baseEntity = baseEntity;
    }

    public DictConfig getDictConfig() {
        return this.dictConfig;
    }

    public void setDictConfig(DictConfig dictConfig) {
        this.dictConfig = dictConfig;
    }

    public DtoConfig getDtoConfig() {
        return this.dtoConfig;
    }

    public void setDtoConfig(DtoConfig dtoConfig) {
        this.dtoConfig = dtoConfig;
    }
}

