/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.gen.engine;

import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.xforceplus.ultraman.bocp.gen.config.ApplicationConfig;
import com.xforceplus.ultraman.bocp.gen.config.BocpConfigBuilder;
import com.xforceplus.ultraman.bocp.gen.config.BocpTemplateConfig;
import com.xforceplus.ultraman.bocp.gen.engine.VelocityTemplateEngine;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationVelocityTemplateEngine
extends VelocityTemplateEngine {
    protected static final Logger logger = LoggerFactory.getLogger(ApplicationVelocityTemplateEngine.class);

    @Override
    public ApplicationVelocityTemplateEngine batchOutput() {
        try {
            ApplicationConfig applicationConfig = this.getBocpConfigBuilder().getApplicationConfig();
            Map<String, String> pathInfo = this.getBocpConfigBuilder().getPathInfo();
            BocpTemplateConfig template = this.getBocpConfigBuilder().getBocpTemplate();
            if (null != applicationConfig.getName()) {
                Map<String, Object> objectMap = this.getObjectMap();
                String parentPomFile = String.format(pathInfo.get("parent_pom_path") + File.separator + "%s" + ".xml", "pom");
                this.writer(objectMap, this.templateFilePath(template.getApplicationParentPom()), parentPomFile);
                String gitigoreFile = String.format(pathInfo.get("gitignore_path") + File.separator + "%s", ".gitignore");
                this.writer(objectMap, this.templateFilePath(template.getGitignore()), gitigoreFile);
                String gitlabCiYmlFile = String.format(pathInfo.get("gitlab_path") + File.separator + "%s" + ".yml", ".gitlab-ci");
                this.writer(objectMap, this.templateFilePath(template.getGitlab()), gitlabCiYmlFile);
                String applicationYmlFile = String.format(pathInfo.get("application_yml_path") + File.separator + "%s" + ".yml", "application");
                this.writer(objectMap, this.templateFilePath(template.getApplicationYml()), applicationYmlFile);
                String pomFile = String.format(pathInfo.get("pom_path") + File.separator + "%s" + ".xml", "pom");
                this.writer(objectMap, this.templateFilePath(template.getApplicationPom()), pomFile);
                String servicePomFile = String.format(pathInfo.get("service_pom_path") + File.separator + "%s" + ".xml", "pom");
                this.writer(objectMap, this.templateFilePath(template.getServicePom()), servicePomFile);
            }
        }
        catch (Exception e) {
            logger.error("\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01", (Throwable)e);
        }
        return this;
    }

    public Map<String, Object> getObjectMap() {
        HashMap<String, Object> objectMap = new HashMap<String, Object>(30);
        BocpConfigBuilder config = this.getBocpConfigBuilder();
        objectMap.put("config", config);
        objectMap.put("application", config.getApplicationConfig());
        objectMap.put("project", config.getProjectConfig());
        objectMap.put("package", config.getPackageInfo());
        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put("author", globalConfig.getAuthor());
        objectMap.put("idType", globalConfig.getIdType() == null ? null : globalConfig.getIdType().toString());
        objectMap.put("logicDeleteFieldName", config.getStrategyConfig().getLogicDeleteFieldName());
        objectMap.put("versionFieldName", config.getStrategyConfig().getVersionFieldName());
        objectMap.put("activeRecord", globalConfig.isActiveRecord());
        objectMap.put("kotlin", globalConfig.isKotlin());
        objectMap.put("swagger2", globalConfig.isSwagger2());
        objectMap.put("date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        objectMap.put("enableCache", globalConfig.isEnableCache());
        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }
}

