/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.gen.engine;

import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.xforceplus.ultraman.bocp.gen.config.BocpConfigBuilder;
import com.xforceplus.ultraman.bocp.gen.config.BocpTemplateConfig;
import com.xforceplus.ultraman.bocp.gen.engine.VelocityTemplateEngine;
import com.xforceplus.ultraman.bocp.gen.po.DictGenInfo;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictVelocityTemplateEngine
extends VelocityTemplateEngine {
    protected static final Logger logger = LoggerFactory.getLogger(DictVelocityTemplateEngine.class);

    @Override
    public DictVelocityTemplateEngine batchOutput() {
        try {
            List<DictGenInfo> dictGenInfos = this.getBocpConfigBuilder().getDictConfig().getDictGenInfos();
            for (DictGenInfo dictGenInfo : dictGenInfos) {
                Map<String, Object> objectMap = this.getObjectMap(dictGenInfo);
                Map<String, String> pathInfo = this.getBocpConfigBuilder().getPathInfo();
                BocpTemplateConfig template = this.getBocpConfigBuilder().getBocpTemplate();
                if (null == dictGenInfo.getCode() || null == pathInfo.get("enum_path")) continue;
                String entityFile = String.format(pathInfo.get("enum_path") + File.separator + "%s" + this.suffixJavaOrKt(), dictGenInfo.getCode());
                this.writer(objectMap, this.templateFilePath(template.getEnum(this.getBocpConfigBuilder().getGlobalConfig().isKotlin())), entityFile);
            }
        }
        catch (Exception e) {
            logger.error("\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01", (Throwable)e);
        }
        return this;
    }

    public Map<String, Object> getObjectMap(DictGenInfo dictGenInfo) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>(30);
        BocpConfigBuilder config = this.getBocpConfigBuilder();
        objectMap.put("config", config);
        objectMap.put("application", config.getApplicationConfig());
        objectMap.put("project", config.getProjectConfig());
        objectMap.put("module", config.getModuleConfig());
        objectMap.put("package", config.getPackageInfo());
        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put("author", globalConfig.getAuthor());
        objectMap.put("idType", globalConfig.getIdType() == null ? null : globalConfig.getIdType().toString());
        objectMap.put("logicDeleteFieldName", config.getStrategyConfig().getLogicDeleteFieldName());
        objectMap.put("versionFieldName", config.getStrategyConfig().getVersionFieldName());
        objectMap.put("activeRecord", globalConfig.isActiveRecord());
        objectMap.put("kotlin", globalConfig.isKotlin());
        objectMap.put("swagger2", globalConfig.isSwagger2());
        objectMap.put("dict", dictGenInfo);
        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }
}

