/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.gen.engine;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.xforceplus.ultraman.bocp.gen.config.BocpConfigBuilder;
import com.xforceplus.ultraman.bocp.gen.config.BocpTemplateConfig;
import com.xforceplus.ultraman.bocp.gen.engine.VelocityTemplateEngine;
import com.xforceplus.ultraman.bocp.gen.po.DtoGenInfo;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DtoVelocityTemplateEngine
extends VelocityTemplateEngine {
    protected static final Logger logger = LoggerFactory.getLogger(DtoVelocityTemplateEngine.class);

    @Override
    public DtoVelocityTemplateEngine batchOutput() {
        try {
            if (this.getBocpConfigBuilder().getDtoConfig() != null && this.getBocpConfigBuilder().getDtoConfig().getDtoGenInfos() != null) {
                List<DtoGenInfo> dtoGenInfoList = this.getBocpConfigBuilder().getDtoConfig().getDtoGenInfos();
                for (DtoGenInfo dtoGenInfo : dtoGenInfoList) {
                    Map<String, Object> objectMap = this.getObjectMap(dtoGenInfo);
                    Map<String, String> pathInfo = this.getBocpConfigBuilder().getPathInfo();
                    BocpTemplateConfig template = this.getBocpConfigBuilder().getBocpTemplate();
                    String dtoName = StringUtils.capitalize((String)dtoGenInfo.getCode());
                    if (null == dtoName || null == pathInfo.get("dto_path")) continue;
                    String dtoFile = String.format(pathInfo.get("dto_path") + File.separator + "%s" + this.suffixJavaOrKt(), dtoName);
                    this.writer(objectMap, this.templateFilePath(template.getDto(this.getBocpConfigBuilder().getGlobalConfig().isKotlin())), dtoFile);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01", (Throwable)e);
        }
        return this;
    }

    public Map<String, Object> getObjectMap(DtoGenInfo dtoGenInfo) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>(30);
        BocpConfigBuilder config = this.getBocpConfigBuilder();
        objectMap.put("config", config);
        objectMap.put("application", config.getApplicationConfig());
        objectMap.put("project", config.getProjectConfig());
        objectMap.put("module", config.getModuleConfig());
        objectMap.put("package", config.getPackageInfo());
        objectMap.put("dataSource", config.getDataSourceConfig());
        objectMap.put("dtoname", StringUtils.capitalize((String)dtoGenInfo.getCode()));
        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put("author", globalConfig.getAuthor());
        objectMap.put("kotlin", globalConfig.isKotlin());
        objectMap.put("date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        objectMap.put("enableCache", globalConfig.isEnableCache());
        objectMap.put("dtoInfo", dtoGenInfo);
        objectMap.put("dto", dtoGenInfo.getCode());
        objectMap.put("dtoSerialVersionUID", config.getStrategyConfig().isEntitySerialVersionUID());
        objectMap.put("dtoColumnConstant", config.getStrategyConfig().isEntityColumnConstant());
        objectMap.put("dtoBuilderModel", config.getStrategyConfig().isEntityBuilderModel());
        objectMap.put("dtoLombokModel", config.getStrategyConfig().isEntityLombokModel());
        objectMap.put("dtoBooleanColumnRemoveIsPrefix", config.getStrategyConfig().isEntityBooleanColumnRemoveIsPrefix());
        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }
}

