/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.gen.engine;

import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.xforceplus.ultraman.bocp.gen.config.ApplicationConfig;
import com.xforceplus.ultraman.bocp.gen.config.BocpConfigBuilder;
import com.xforceplus.ultraman.bocp.gen.config.BocpTemplateConfig;
import com.xforceplus.ultraman.bocp.gen.config.ModuleConfig;
import com.xforceplus.ultraman.bocp.gen.engine.VelocityTemplateEngine;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleVelocityTemplateEngine
extends VelocityTemplateEngine {
    protected static final Logger logger = LoggerFactory.getLogger(ModuleVelocityTemplateEngine.class);

    @Override
    public ModuleVelocityTemplateEngine batchOutput() {
        try {
            ModuleConfig moduleConfig = this.getBocpConfigBuilder().getModuleConfig();
            ApplicationConfig applicationConfig = this.getBocpConfigBuilder().getApplicationConfig();
            Map<String, String> pathInfo = this.getBocpConfigBuilder().getPathInfo();
            BocpTemplateConfig template = this.getBocpConfigBuilder().getBocpTemplate();
            if (null != moduleConfig.getName() && null != applicationConfig.getName()) {
                Map<String, Object> objectMap = this.getObjectMap();
                String parentPomFile = String.format(pathInfo.get("module_parent_pom_path") + File.separator + "%s" + ".xml", "pom");
                this.writer(objectMap, this.templateFilePath(template.getModuleParentPom()), parentPomFile);
                String gitigoreFile = String.format(pathInfo.get("module_gitignore_path") + File.separator + "%s", ".gitigore");
                this.writer(objectMap, this.templateFilePath(template.getModuleGitignore()), gitigoreFile);
                String gitlabCiYmlFile = String.format(pathInfo.get("module_gitlab_path") + File.separator + "%s" + ".yml", ".gitlab-ci");
                this.writer(objectMap, this.templateFilePath(template.getModuleGitlab()), gitlabCiYmlFile);
                String applicationYmlFile = String.format(pathInfo.get("module_application_yml_path") + File.separator + "%s" + ".yml", "application");
                this.writer(objectMap, this.templateFilePath(template.getModuleApplicationYml()), applicationYmlFile);
                String clientPomFile = String.format(pathInfo.get("module_client_pom_path") + File.separator + "%s" + ".xml", "pom");
                this.writer(objectMap, this.templateFilePath(template.getModuleClientPom()), clientPomFile);
                String pomFile = String.format(pathInfo.get("module_pom_path") + File.separator + "%s" + ".xml", "pom");
                this.writer(objectMap, this.templateFilePath(template.getModulePom()), pomFile);
                String servicePomFile = String.format(pathInfo.get("module_service_pom_path") + File.separator + "%s" + ".xml", "pom");
                this.writer(objectMap, this.templateFilePath(template.getModuleServicePom()), servicePomFile);
                String domainPomFile = String.format(pathInfo.get("module_domain_pom_path") + File.separator + "%s" + ".xml", "pom");
                this.writer(objectMap, this.templateFilePath(template.getModuleDomainPom()), domainPomFile);
            }
        }
        catch (Exception e) {
            logger.error("\u65e0\u6cd5\u521b\u5efa\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u4fe1\u606f\uff01", (Throwable)e);
        }
        return this;
    }

    public Map<String, Object> getObjectMap() {
        HashMap<String, Object> objectMap = new HashMap<String, Object>(30);
        BocpConfigBuilder config = this.getBocpConfigBuilder();
        objectMap.put("config", config);
        objectMap.put("application", config.getApplicationConfig());
        objectMap.put("project", config.getProjectConfig());
        objectMap.put("module", config.getModuleConfig());
        objectMap.put("package", config.getPackageInfo());
        objectMap.put("dataSource", config.getDataSourceConfig());
        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put("author", globalConfig.getAuthor());
        objectMap.put("idType", globalConfig.getIdType() == null ? null : globalConfig.getIdType().toString());
        objectMap.put("logicDeleteFieldName", config.getStrategyConfig().getLogicDeleteFieldName());
        objectMap.put("versionFieldName", config.getStrategyConfig().getVersionFieldName());
        objectMap.put("activeRecord", globalConfig.isActiveRecord());
        objectMap.put("kotlin", globalConfig.isKotlin());
        objectMap.put("swagger2", globalConfig.isSwagger2());
        objectMap.put("date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }
}

