/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.gen.engine;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.rules.FileType;
import com.xforceplus.ultraman.bocp.gen.config.BocpConfigBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VelocityTemplateEngine {
    protected static final Logger logger = LoggerFactory.getLogger(VelocityTemplateEngine.class);
    public static final String DOT_VM = ".vm";
    protected VelocityEngine velocityEngine;
    protected BocpConfigBuilder bocpConfigBuilder;

    public VelocityTemplateEngine init(BocpConfigBuilder bocpConfigBuilder) {
        this.bocpConfigBuilder = bocpConfigBuilder;
        if (null == this.velocityEngine) {
            Properties p = new Properties();
            p.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            p.setProperty("resource.loader.file.path", "");
            p.setProperty("UTF-8", ConstVal.UTF8);
            p.setProperty("resource.default_encoding", ConstVal.UTF8);
            p.setProperty("file.resource.loader.unicode", "true");
            this.velocityEngine = new VelocityEngine(p);
        }
        return this;
    }

    public void writer(Map<String, Object> objectMap, String templatePath, String outputFile) throws Exception {
        if (StringUtils.isEmpty((CharSequence)templatePath)) {
            return;
        }
        Template template = this.velocityEngine.getTemplate(templatePath, ConstVal.UTF8);
        try (FileOutputStream fos = new FileOutputStream(outputFile);
             OutputStreamWriter ow = new OutputStreamWriter((OutputStream)fos, ConstVal.UTF8);
             BufferedWriter writer = new BufferedWriter(ow);){
            template.merge((Context)new VelocityContext(objectMap), (Writer)writer);
        }
        System.out.println("\u6a21\u677f:" + templatePath + ";  \u6587\u4ef6:" + outputFile);
        logger.debug("\u6a21\u677f:" + templatePath + ";  \u6587\u4ef6:" + outputFile);
    }

    public String templateFilePath(String filePath) {
        if (null == filePath || filePath.contains(DOT_VM)) {
            return filePath;
        }
        return filePath + DOT_VM;
    }

    public abstract VelocityTemplateEngine batchOutput();

    public VelocityTemplateEngine mkdirs() {
        this.getBocpConfigBuilder().getPathInfo().forEach((key, value) -> {
            boolean result;
            File dir = new File((String)value);
            if (!dir.exists() && (result = dir.mkdirs())) {
                logger.debug("\u521b\u5efa\u76ee\u5f55\uff1a [" + value + "]");
            }
        });
        return this;
    }

    public void open() {
        String outDir = this.getBocpConfigBuilder().getGlobalConfig().getOutputDir();
        if (this.getBocpConfigBuilder().getGlobalConfig().isOpen() && StringUtils.isNotEmpty((CharSequence)outDir)) {
            try {
                String osName = System.getProperty("os.name");
                if (osName != null) {
                    if (osName.contains("Mac")) {
                        Runtime.getRuntime().exec("open " + outDir);
                    } else if (osName.contains("Windows")) {
                        Runtime.getRuntime().exec("cmd /c start " + outDir);
                    } else {
                        logger.debug("\u6587\u4ef6\u8f93\u51fa\u76ee\u5f55:" + outDir);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected String getSuperClassName(String classPath) {
        if (StringUtils.isEmpty((CharSequence)classPath)) {
            return null;
        }
        return classPath.substring(classPath.lastIndexOf(".") + 1);
    }

    protected boolean isCreate(FileType fileType, String filePath) {
        BocpConfigBuilder cb = this.getBocpConfigBuilder();
        File file = new File(filePath);
        boolean exist = file.exists();
        if (!exist) {
            file.getParentFile().mkdirs();
        }
        return !exist || this.getBocpConfigBuilder().getGlobalConfig().isFileOverride();
    }

    protected String suffixJavaOrKt() {
        return this.getBocpConfigBuilder().getGlobalConfig().isKotlin() ? ".kt" : ".java";
    }

    public BocpConfigBuilder getBocpConfigBuilder() {
        return this.bocpConfigBuilder;
    }

    public void setBocpConfigBuilder(BocpConfigBuilder bocpConfigBuilder) {
        this.bocpConfigBuilder = bocpConfigBuilder;
    }
}

