/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.gen.generator;

import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.xforceplus.ultraman.bocp.gen.config.ApplicationConfig;
import com.xforceplus.ultraman.bocp.gen.config.BoConfig;
import com.xforceplus.ultraman.bocp.gen.config.BocpConfigBuilder;
import com.xforceplus.ultraman.bocp.gen.config.BocpTemplateConfig;
import com.xforceplus.ultraman.bocp.gen.config.DictConfig;
import com.xforceplus.ultraman.bocp.gen.config.DtoConfig;
import com.xforceplus.ultraman.bocp.gen.config.ModuleConfig;
import com.xforceplus.ultraman.bocp.gen.config.ProjectConfig;
import com.xforceplus.ultraman.bocp.gen.constant.EngineType;
import com.xforceplus.ultraman.bocp.gen.engine.VelocityTemplateEngine;
import com.xforceplus.ultraman.bocp.gen.generator.VelocityTemplateEngineFactory;
import com.xforceplus.ultraman.bocp.gen.util.FileUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BocpAutoGenerator {
    private static final Logger logger = LoggerFactory.getLogger(BocpAutoGenerator.class);
    private BocpTemplateConfig template;
    private ProjectConfig projectConfig;
    private ApplicationConfig applicationConfig;
    private ModuleConfig moduleConfig;
    protected BocpConfigBuilder bocpConfig;
    private BoConfig boConfig;
    private DictConfig dictConfig;
    private DtoConfig dtoConfig;
    private DataSourceConfig dataSource;
    private StrategyConfig strategy;
    private PackageConfig packageInfo;
    private GlobalConfig globalConfig;
    private VelocityTemplateEngineFactory templateEngineFactory = new VelocityTemplateEngineFactory();
    private String engineType;

    public void execute() {
        logger.debug("==========================\u51c6\u5907\u751f\u6210\u6587\u4ef6...==========================");
        if (null == this.bocpConfig) {
            this.bocpConfig = new BocpConfigBuilder(this.projectConfig, this.applicationConfig, this.moduleConfig, this.boConfig, this.dictConfig, this.dtoConfig, this.packageInfo, this.dataSource, this.strategy, this.template, this.globalConfig);
        }
        Map<String, String> pathInfo = this.pretreatmentConfigBuilder(this.bocpConfig).getPathInfo();
        if (this.engineType == null || Arrays.asList("app", "mo").contains(this.engineType)) {
            FileUtil.delAllFile(pathInfo.get("parent_pom_path"));
        }
        if (this.engineType == null) {
            Arrays.asList("app", "mo", "bo", "dict", "dto").forEach(type -> this.doExecute((String)type));
        } else {
            this.doExecute(this.engineType);
        }
    }

    void doExecute(String type) {
        VelocityTemplateEngine engine = this.templateEngineFactory.getVelocityTemplateEngine(type);
        if (engine != null) {
            this.templateEngineFactory.getVelocityTemplateEngine(this.engineType).init(this.pretreatmentConfigBuilder(this.bocpConfig)).mkdirs().batchOutput().open();
            logger.debug(String.format("==========================%s\u6587\u4ef6\u751f\u6210\u5b8c\u6210\uff01\uff01\uff01==========================", EngineType.fromCode(type).name()));
        } else {
            logger.debug(String.format("==========================%s\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u627e\u4e0d\u5230\u6a21\u677f\u5f15\u64ce\uff01\uff01\uff01==========================", EngineType.fromCode(type).name()));
        }
    }

    protected List<TableInfo> getAllTableInfoList(BocpConfigBuilder bocpConfig) {
        return bocpConfig.getTableInfoList();
    }

    protected BocpConfigBuilder pretreatmentConfigBuilder(BocpConfigBuilder bocpconfig) {
        List<TableInfo> tableList = this.getAllTableInfoList(bocpconfig);
        if (tableList != null) {
            for (TableInfo tableInfo : tableList) {
                if (this.bocpConfig.getGlobalConfig().isActiveRecord()) {
                    tableInfo.setImportPackages(Model.class.getCanonicalName());
                }
                if (tableInfo.isConvert()) {
                    tableInfo.setImportPackages(TableName.class.getCanonicalName());
                }
                if (this.bocpConfig.getStrategyConfig().getLogicDeleteFieldName() != null && tableInfo.isLogicDelete(bocpconfig.getStrategyConfig().getLogicDeleteFieldName())) {
                    tableInfo.setImportPackages(TableLogic.class.getCanonicalName());
                }
                if (StringUtils.isNotEmpty((CharSequence)bocpconfig.getStrategyConfig().getVersionFieldName())) {
                    tableInfo.setImportPackages(Version.class.getCanonicalName());
                }
                boolean importSerializable = true;
                if (StringUtils.isNotEmpty((CharSequence)bocpconfig.getSuperEntityClass())) {
                    tableInfo.setImportPackages(bocpconfig.getSuperEntityClass());
                    importSerializable = false;
                }
                if (bocpconfig.getGlobalConfig().isActiveRecord()) {
                    importSerializable = true;
                }
                if (importSerializable) {
                    tableInfo.setImportPackages(Serializable.class.getCanonicalName());
                }
                if (!bocpconfig.getStrategyConfig().isEntityBooleanColumnRemoveIsPrefix() || !CollectionUtils.isNotEmpty((Collection)tableInfo.getFields())) continue;
                tableInfo.getFields().stream().filter(field -> "boolean".equalsIgnoreCase(field.getPropertyType())).filter(field -> field.getPropertyName().startsWith("is")).forEach(field -> {
                    field.setConvert(true);
                    field.setPropertyName(StringUtils.removePrefixAfterPrefixToLower((String)field.getPropertyName(), (int)2));
                });
            }
        }
        return bocpconfig.setTableInfoList(tableList);
    }

    public BocpTemplateConfig getTemplate() {
        return this.template;
    }

    public ProjectConfig getProjectConfig() {
        return this.projectConfig;
    }

    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public ModuleConfig getModuleConfig() {
        return this.moduleConfig;
    }

    public BocpConfigBuilder getBocpConfig() {
        return this.bocpConfig;
    }

    public BoConfig getBoConfig() {
        return this.boConfig;
    }

    public DictConfig getDictConfig() {
        return this.dictConfig;
    }

    public DtoConfig getDtoConfig() {
        return this.dtoConfig;
    }

    public DataSourceConfig getDataSource() {
        return this.dataSource;
    }

    public StrategyConfig getStrategy() {
        return this.strategy;
    }

    public PackageConfig getPackageInfo() {
        return this.packageInfo;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public String getEngineType() {
        return this.engineType;
    }

    public void setTemplate(BocpTemplateConfig template) {
        this.template = template;
    }

    public void setProjectConfig(ProjectConfig projectConfig) {
        this.projectConfig = projectConfig;
    }

    public void setApplicationConfig(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
    }

    public void setModuleConfig(ModuleConfig moduleConfig) {
        this.moduleConfig = moduleConfig;
    }

    public void setBocpConfig(BocpConfigBuilder bocpConfig) {
        this.bocpConfig = bocpConfig;
    }

    public void setBoConfig(BoConfig boConfig) {
        this.boConfig = boConfig;
    }

    public void setDictConfig(DictConfig dictConfig) {
        this.dictConfig = dictConfig;
    }

    public void setDtoConfig(DtoConfig dtoConfig) {
        this.dtoConfig = dtoConfig;
    }

    public void setDataSource(DataSourceConfig dataSource) {
        this.dataSource = dataSource;
    }

    public void setStrategy(StrategyConfig strategy) {
        this.strategy = strategy;
    }

    public void setPackageInfo(PackageConfig packageInfo) {
        this.packageInfo = packageInfo;
    }

    public void setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }

    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BocpAutoGenerator)) {
            return false;
        }
        BocpAutoGenerator other = (BocpAutoGenerator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BocpTemplateConfig this$template = this.getTemplate();
        BocpTemplateConfig other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !((Object)this$template).equals(other$template)) {
            return false;
        }
        ProjectConfig this$projectConfig = this.getProjectConfig();
        ProjectConfig other$projectConfig = other.getProjectConfig();
        if (this$projectConfig == null ? other$projectConfig != null : !((Object)this$projectConfig).equals(other$projectConfig)) {
            return false;
        }
        ApplicationConfig this$applicationConfig = this.getApplicationConfig();
        ApplicationConfig other$applicationConfig = other.getApplicationConfig();
        if (this$applicationConfig == null ? other$applicationConfig != null : !((Object)this$applicationConfig).equals(other$applicationConfig)) {
            return false;
        }
        ModuleConfig this$moduleConfig = this.getModuleConfig();
        ModuleConfig other$moduleConfig = other.getModuleConfig();
        if (this$moduleConfig == null ? other$moduleConfig != null : !((Object)this$moduleConfig).equals(other$moduleConfig)) {
            return false;
        }
        BocpConfigBuilder this$bocpConfig = this.getBocpConfig();
        BocpConfigBuilder other$bocpConfig = other.getBocpConfig();
        if (this$bocpConfig == null ? other$bocpConfig != null : !this$bocpConfig.equals(other$bocpConfig)) {
            return false;
        }
        BoConfig this$boConfig = this.getBoConfig();
        BoConfig other$boConfig = other.getBoConfig();
        if (this$boConfig == null ? other$boConfig != null : !((Object)this$boConfig).equals(other$boConfig)) {
            return false;
        }
        DictConfig this$dictConfig = this.getDictConfig();
        DictConfig other$dictConfig = other.getDictConfig();
        if (this$dictConfig == null ? other$dictConfig != null : !((Object)this$dictConfig).equals(other$dictConfig)) {
            return false;
        }
        DtoConfig this$dtoConfig = this.getDtoConfig();
        DtoConfig other$dtoConfig = other.getDtoConfig();
        if (this$dtoConfig == null ? other$dtoConfig != null : !this$dtoConfig.equals(other$dtoConfig)) {
            return false;
        }
        DataSourceConfig this$dataSource = this.getDataSource();
        DataSourceConfig other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        StrategyConfig this$strategy = this.getStrategy();
        StrategyConfig other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !this$strategy.equals(other$strategy)) {
            return false;
        }
        PackageConfig this$packageInfo = this.getPackageInfo();
        PackageConfig other$packageInfo = other.getPackageInfo();
        if (this$packageInfo == null ? other$packageInfo != null : !this$packageInfo.equals(other$packageInfo)) {
            return false;
        }
        GlobalConfig this$globalConfig = this.getGlobalConfig();
        GlobalConfig other$globalConfig = other.getGlobalConfig();
        if (this$globalConfig == null ? other$globalConfig != null : !this$globalConfig.equals(other$globalConfig)) {
            return false;
        }
        VelocityTemplateEngineFactory this$templateEngineFactory = this.templateEngineFactory;
        VelocityTemplateEngineFactory other$templateEngineFactory = other.templateEngineFactory;
        if (this$templateEngineFactory == null ? other$templateEngineFactory != null : !this$templateEngineFactory.equals(other$templateEngineFactory)) {
            return false;
        }
        String this$engineType = this.getEngineType();
        String other$engineType = other.getEngineType();
        return !(this$engineType == null ? other$engineType != null : !this$engineType.equals(other$engineType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BocpAutoGenerator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BocpTemplateConfig $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : ((Object)$template).hashCode());
        ProjectConfig $projectConfig = this.getProjectConfig();
        result = result * 59 + ($projectConfig == null ? 43 : ((Object)$projectConfig).hashCode());
        ApplicationConfig $applicationConfig = this.getApplicationConfig();
        result = result * 59 + ($applicationConfig == null ? 43 : ((Object)$applicationConfig).hashCode());
        ModuleConfig $moduleConfig = this.getModuleConfig();
        result = result * 59 + ($moduleConfig == null ? 43 : ((Object)$moduleConfig).hashCode());
        BocpConfigBuilder $bocpConfig = this.getBocpConfig();
        result = result * 59 + ($bocpConfig == null ? 43 : $bocpConfig.hashCode());
        BoConfig $boConfig = this.getBoConfig();
        result = result * 59 + ($boConfig == null ? 43 : ((Object)$boConfig).hashCode());
        DictConfig $dictConfig = this.getDictConfig();
        result = result * 59 + ($dictConfig == null ? 43 : ((Object)$dictConfig).hashCode());
        DtoConfig $dtoConfig = this.getDtoConfig();
        result = result * 59 + ($dtoConfig == null ? 43 : $dtoConfig.hashCode());
        DataSourceConfig $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        StrategyConfig $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 43 : $strategy.hashCode());
        PackageConfig $packageInfo = this.getPackageInfo();
        result = result * 59 + ($packageInfo == null ? 43 : $packageInfo.hashCode());
        GlobalConfig $globalConfig = this.getGlobalConfig();
        result = result * 59 + ($globalConfig == null ? 43 : $globalConfig.hashCode());
        VelocityTemplateEngineFactory $templateEngineFactory = this.templateEngineFactory;
        result = result * 59 + ($templateEngineFactory == null ? 43 : $templateEngineFactory.hashCode());
        String $engineType = this.getEngineType();
        result = result * 59 + ($engineType == null ? 43 : $engineType.hashCode());
        return result;
    }

    public String toString() {
        return "BocpAutoGenerator(template=" + this.getTemplate() + ", projectConfig=" + this.getProjectConfig() + ", applicationConfig=" + this.getApplicationConfig() + ", moduleConfig=" + this.getModuleConfig() + ", bocpConfig=" + this.getBocpConfig() + ", boConfig=" + this.getBoConfig() + ", dictConfig=" + this.getDictConfig() + ", dtoConfig=" + this.getDtoConfig() + ", dataSource=" + this.getDataSource() + ", strategy=" + this.getStrategy() + ", packageInfo=" + this.getPackageInfo() + ", globalConfig=" + this.getGlobalConfig() + ", templateEngineFactory=" + this.templateEngineFactory + ", engineType=" + this.getEngineType() + ")";
    }
}

