/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.gen.generator;

import com.xforceplus.ultraman.bocp.gen.engine.ApplicationVelocityTemplateEngine;
import com.xforceplus.ultraman.bocp.gen.engine.BoVelocityTemplateEngine;
import com.xforceplus.ultraman.bocp.gen.engine.DictVelocityTemplateEngine;
import com.xforceplus.ultraman.bocp.gen.engine.DtoVelocityTemplateEngine;
import com.xforceplus.ultraman.bocp.gen.engine.ModuleVelocityTemplateEngine;
import com.xforceplus.ultraman.bocp.gen.engine.VelocityTemplateEngine;
import java.util.HashMap;
import java.util.Map;

public class VelocityTemplateEngineFactory {
    private Map<String, VelocityTemplateEngine> templateEngineMap = new HashMap<String, VelocityTemplateEngine>();

    public synchronized VelocityTemplateEngine getVelocityTemplateEngine(String engineType) {
        VelocityTemplateEngine engine = this.templateEngineMap.get(engineType);
        if (engine == null) {
            switch (engineType) {
                case "app": {
                    engine = new ApplicationVelocityTemplateEngine();
                    break;
                }
                case "mo": {
                    engine = new ModuleVelocityTemplateEngine();
                    break;
                }
                case "bo": {
                    engine = new BoVelocityTemplateEngine();
                    break;
                }
                case "dto": {
                    engine = new DtoVelocityTemplateEngine();
                    break;
                }
                case "dict": {
                    engine = new DictVelocityTemplateEngine();
                    break;
                }
            }
            if (engine != null) {
                this.templateEngineMap.put(engineType, engine);
            }
        }
        return engine;
    }
}

