package com.xforceplus.ultraman.bocp.gen.engine;

import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.xforceplus.ultraman.bocp.gen.config.ApplicationConfig;
import com.xforceplus.ultraman.bocp.gen.config.BocpConfigBuilder;
import com.xforceplus.ultraman.bocp.gen.config.BocpConstVal;
import com.xforceplus.ultraman.bocp.gen.config.BocpTemplateConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ApplicationVelocityTemplateEngine extends VelocityTemplateEngine {
    protected static final Logger logger = LoggerFactory.getLogger(ApplicationVelocityTemplateEngine.class);

    /**
     * 输出 java xml 文件
     */
    @Override
    public ApplicationVelocityTemplateEngine batchOutput() {
        try {
            ApplicationConfig applicationConfig = getBocpConfigBuilder().getApplicationConfig();
            Map<String, String> pathInfo = getBocpConfigBuilder().getPathInfo();
            BocpTemplateConfig template = getBocpConfigBuilder().getBocpTemplate();
            if (null != applicationConfig.getName()) {
                Map<String, Object> objectMap = getObjectMap();
                String parentPomFile = String.format(pathInfo.get(BocpConstVal.PARENT_POM_PATH) + File.separator + "%s" + ConstVal.XML_SUFFIX, "pom");
                writer(objectMap, templateFilePath(template.getApplicationParentPom()), parentPomFile);

                String gitigoreFile = String.format(pathInfo.get(BocpConstVal.GITIGNORE_PATH) + File.separator + "%s", ".gitignore");
                writer(objectMap, templateFilePath(template.getGitignore()), gitigoreFile);

                String gitlabCiYmlFile = String.format(pathInfo.get(BocpConstVal.GITLAB_PATH) + File.separator + "%s" + BocpConstVal.YML_SUFFIX, ".gitlab-ci");
                writer(objectMap, templateFilePath(template.getGitlab()), gitlabCiYmlFile);

                String applicationYmlFile =  String.format(pathInfo.get(BocpConstVal.APPLICATION_YML_PATH) + File.separator + "%s" + BocpConstVal.YML_SUFFIX, "application");
                writer(objectMap, templateFilePath(template.getApplicationYml()), applicationYmlFile);

//                String clientPomFile = String.format(pathInfo.get(BocpConstVal.CLIENT_POM_PATH) + File.separator + "%s" + ConstVal.XML_SUFFIX, "pom");
//                writer(objectMap, templateFilePath(template.getClientPom()), clientPomFile);

                String pomFile = String.format(pathInfo.get(BocpConstVal.POM_PATH) + File.separator + "%s" + ConstVal.XML_SUFFIX, "pom");
                writer(objectMap, templateFilePath(template.getApplicationPom()), pomFile);

                String servicePomFile = String.format(pathInfo.get(BocpConstVal.SERVICE_POM_PATH) + File.separator + "%s" + ConstVal.XML_SUFFIX, "pom");
                writer(objectMap, templateFilePath(template.getServicePom()), servicePomFile);

//                String serviceApplicationFile = String.format(pathInfo.get(BocpConstVal.SERVICE_APPLICATION_PATH) + File.separator + "%s" + ConstVal.JAVA_SUFFIX, applicationConfig.getAlias() + "ServiceApplication");
//                writer(objectMap, templateFilePath(template.getServiceApplication()), serviceApplicationFile);

//                String serviceApplicationTestFile = String.format(pathInfo.get(BocpConstVal.SERVICE_APPLICATION_TESTS_PATH) + File.separator + "%s" + ConstVal.JAVA_SUFFIX, "serviceApplicationTest");
//                writer(objectMap, templateFilePath(template.getServiceApplicationTest()), serviceApplicationTestFile);
            }
        } catch (Exception e) {
            logger.error("无法创建文件，请检查配置信息！", e);
        }
        return this;
    }

    /**
     * 渲染对象 MAP 信息
     *
     *
     * @return Map
     */
    public Map<String, Object> getObjectMap() {
        Map<String, Object> objectMap = initTemplateParams();
        BocpConfigBuilder config = getBocpConfigBuilder();
        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }

}
