package com.xforceplus.ultraman.bocp.gen.engine;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.xforceplus.ultraman.bocp.gen.config.BocpConfigBuilder;
import com.xforceplus.ultraman.bocp.gen.config.BocpTemplateConfig;
import com.xforceplus.ultraman.bocp.gen.po.BoGenInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.beans.Introspector;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.*;

public class BaseEntityVelocityTemplateEngine extends VelocityTemplateEngine {
    protected static final Logger logger = LoggerFactory.getLogger(BaseEntityVelocityTemplateEngine.class);

    /**
     * 输出 java xml 文件
     */
    @Override
    public BaseEntityVelocityTemplateEngine batchOutput() {
        try {
            List<TableInfo> tableInfoList = getBocpConfigBuilder().getTableInfoList();
            for (TableInfo tableInfo : tableInfoList) {
                Map<String, Object> objectMap = getObjectMap(tableInfo);
                Map<String, String> pathInfo = getBocpConfigBuilder().getPathInfo();
                BocpTemplateConfig template = getBocpConfigBuilder().getBocpTemplate();

                // Mp.java
                String entityName = tableInfo.getEntityName();
                if (null != entityName && null != pathInfo.get(ConstVal.ENTITY_PATH)) {
                    String entityFile = String.format((pathInfo.get(ConstVal.ENTITY_PATH) + File.separator + "%s" + suffixJavaOrKt()), entityName);
                    writer(objectMap, templateFilePath(template.getEntity(getBocpConfigBuilder().getGlobalConfig().isKotlin())), entityFile);
//                    if (isCreate(FileType.ENTITY, entityFile)) {
//                        writer(objectMap, templateFilePath(template.getEntity(getBocpConfigBuilder().getGlobalConfig().isKotlin())), entityFile);
//                    }
                }

            }
        } catch (Exception e) {
            logger.error("无法创建文件，请检查配置信息！", e);
        }
        return this;
    }

    /**
     * 渲染对象 MAP 信息
     *
     * @param tableInfo 表信息对象
     * @return ignore
     */
    public Map<String, Object> getObjectMap(TableInfo tableInfo) {
        Map<String, Object> objectMap = initTemplateParams();
        BocpConfigBuilder config = getBocpConfigBuilder();
        GlobalConfig globalConfig = config.getGlobalConfig();
        //将参数放入map中用于模板解析
        objectMap.put("entityname",StringUtils.firstToLowerCase(tableInfo.getEntityName()));
        objectMap.put("idType", globalConfig.getIdType() == null ? null : globalConfig.getIdType().toString());
        objectMap.put("logicDeleteFieldName", config.getStrategyConfig().getLogicDeleteFieldName());
        objectMap.put("versionFieldName", config.getStrategyConfig().getVersionFieldName());
        objectMap.put("activeRecord", globalConfig.isActiveRecord());
        objectMap.put("kotlin", globalConfig.isKotlin());
        objectMap.put("swagger2", globalConfig.isSwagger2());
        objectMap.put("date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        objectMap.put("table", tableInfo);
        objectMap.put("enableCache", globalConfig.isEnableCache());
        objectMap.put("baseResultMap", globalConfig.isBaseResultMap());
        objectMap.put("baseColumnList", globalConfig.isBaseColumnList());
        objectMap.put("entity", tableInfo.getEntityName());
        objectMap.put("entitySerialVersionUID", config.getStrategyConfig().isEntitySerialVersionUID());
        objectMap.put("entityColumnConstant", config.getStrategyConfig().isEntityColumnConstant());
        objectMap.put("entityBuilderModel", config.getStrategyConfig().isEntityBuilderModel());
        objectMap.put("entityLombokModel", config.getStrategyConfig().isEntityLombokModel());
        objectMap.put("entityBooleanColumnRemoveIsPrefix", config.getStrategyConfig().isEntityBooleanColumnRemoveIsPrefix());
        objectMap.put("superEntityClass", getSuperClassName(config.getSuperEntityClass()));
        objectMap.put("entityId", getBoId(config, tableInfo.getName()));

        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }

    /**
     * 对象固定Id
     */
    private String getBoId(BocpConfigBuilder config, String boName){
        List<BoGenInfo> boGenInfos = config.getBoConfig().getBoGenInfoList() == null
                ? new ArrayList<>():config.getBoConfig().getBoGenInfoList();
        Optional<BoGenInfo> optional = boGenInfos.stream()
                .filter(boGenInfo -> boGenInfo.getName().equals(boName)).findFirst();
        Long id = optional.isPresent() ? optional.get().getId():null;
        return id == null ? "" : id.toString();
    }

}
