package com.xforceplus.ultraman.bocp.gen.engine;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.xforceplus.ultraman.bocp.gen.config.BocpConfigBuilder;
import com.xforceplus.ultraman.bocp.gen.config.BocpConstVal;
import com.xforceplus.ultraman.bocp.gen.config.BocpTemplateConfig;
import com.xforceplus.ultraman.bocp.gen.config.ConstValEx;
import com.xforceplus.ultraman.bocp.gen.po.BoGenField;
import com.xforceplus.ultraman.bocp.gen.po.BoGenInfo;
import com.xforceplus.ultraman.bocp.gen.po.ComboInfo;
import com.xforceplus.ultraman.bocp.gen.util.GenFormatUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.beans.Introspector;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

public class BoVelocityTemplateEngine extends VelocityTemplateEngine {
    protected static final Logger logger = LoggerFactory.getLogger(BoVelocityTemplateEngine.class);

    /**
     * 输出 java xml 文件
     */
    @Override
    public BoVelocityTemplateEngine batchOutput() {
        try {
            if(getBocpConfigBuilder().getStrategyConfig().getSuperEntityClass() != null
                    && getBocpConfigBuilder().getBoConfig().getBaseEntity() != null) {
                TableInfo baseEntity =  getBocpConfigBuilder().getBaseEntity();
                baseEntity.setCommonFields(new ArrayList<>());
                Map<String, String> pathInfo = getBocpConfigBuilder().getPathInfo();
                BocpTemplateConfig template = getBocpConfigBuilder().getBocpTemplate();
                String baseEntityFile = String.format((pathInfo.get(ConstValEx.BASE_ENTITY_PATH) + File.separator + "%s" + suffixJavaOrKt()), baseEntity.getEntityName());
                writer(getObjectMap(baseEntity, null, null), templateFilePath(template.getBaseEntity(getBocpConfigBuilder().getGlobalConfig().isKotlin())), baseEntityFile);
            }

            List<TableInfo> tableInfoList = getBocpConfigBuilder().getTableInfoList();
            Map<String, String> pathInfo = getBocpConfigBuilder().getPathInfo();
            BocpTemplateConfig template = getBocpConfigBuilder().getBocpTemplate();
            List<BoGenInfo> boGenInfoList = getBocpConfigBuilder().getBoConfig().getBoGenInfoList();
            for (TableInfo tableInfo : tableInfoList) {
                BoGenInfo boGenInfo = boGenInfoList == null ? null : boGenInfoList.stream()
                        .filter(bGenInfo -> bGenInfo.getName().equals(tableInfo.getName())).collect(Collectors.toList()).get(0);
                Map<String, Object> objectMap = getObjectMap(tableInfo, boGenInfo, tableInfoList);

                // Mp.java
                String entityName = tableInfo.getEntityName();
                if (null != entityName && null != pathInfo.get(ConstVal.ENTITY_PATH)) {
                    String entityFile = String.format((pathInfo.get(ConstVal.ENTITY_PATH) + File.separator + "%s" + suffixJavaOrKt()), entityName);
                    writer(objectMap, templateFilePath(template.getEntity(getBocpConfigBuilder().getGlobalConfig().isKotlin())), entityFile);
//                    if (isCreate(FileType.ENTITY, entityFile)) {
//                        writer(objectMap, templateFilePath(template.getEntity(getBocpConfigBuilder().getGlobalConfig().isKotlin())), entityFile);
//                    }
                }
                // ComboMp.java
                if(boGenInfo != null && boGenInfo.getComboInfo() != null && boGenInfo.getComboInfo().getRelBos() != null && !boGenInfo.getComboInfo().getRelBos().isEmpty()) {
                    String comboEntityName = String.format("Combo%s", tableInfo.getEntityName());
                    if (null != comboEntityName && null != pathInfo.get(ConstVal.ENTITY_PATH)) {
                        String entityFile = String.format((pathInfo.get(ConstVal.ENTITY_PATH) + File.separator + "%s" + suffixJavaOrKt()), comboEntityName);
                        writer(objectMap, templateFilePath(template.getComboEntity(getBocpConfigBuilder().getGlobalConfig().isKotlin())), entityFile);
                    }
                }
                // MpMapper.java
                if (null != tableInfo.getMapperName() && null != pathInfo.get(ConstVal.MAPPER_PATH)) {
                    String mapperFile = String.format((pathInfo.get(ConstVal.MAPPER_PATH) + File.separator + tableInfo.getMapperName() + suffixJavaOrKt()), entityName);
                    writer(objectMap, templateFilePath(template.getMapper()), mapperFile);
//                    if (isCreate(FileType.MAPPER, mapperFile)) {
//                        writer(objectMap, templateFilePath(template.getMapper()), mapperFile);
//                    }
                }
                // MpMapper.xml
                if (null != tableInfo.getXmlName() && null != pathInfo.get(ConstVal.XML_PATH)) {
                    String xmlFile = String.format((pathInfo.get(ConstVal.XML_PATH) + File.separator + tableInfo.getXmlName() + ConstVal.XML_SUFFIX), entityName);
                    writer(objectMap, templateFilePath(template.getXml()), xmlFile);
//                    if (isCreate(FileType.XML, xmlFile)) {
//                        writer(objectMap, templateFilePath(template.getXml()), xmlFile);
//                    }
                }
                // IMpService.java
                if (null != tableInfo.getServiceName() && null != pathInfo.get(ConstVal.SERVICE_PATH)) {
                    String serviceFile = String.format((pathInfo.get(ConstVal.SERVICE_PATH) + File.separator + tableInfo.getServiceName() + suffixJavaOrKt()), entityName);
                    writer(objectMap, templateFilePath(template.getService()), serviceFile);
//                    if (isCreate(FileType.SERVICE, serviceFile)) {
//                        writer(objectMap, templateFilePath(template.getService()), serviceFile);
//                    }
                }
                // MpServiceImpl.java
                if (null != tableInfo.getServiceImplName() && null != pathInfo.get(ConstVal.SERVICE_IMPL_PATH)) {
                    String implFile = String.format((pathInfo.get(ConstVal.SERVICE_IMPL_PATH) + File.separator + tableInfo.getServiceImplName() + suffixJavaOrKt()), entityName);
                    writer(objectMap, templateFilePath(template.getServiceImpl()), implFile);
//                    if (isCreate(FileType.SERVICE_IMPL, implFile)) {
//                        writer(objectMap, templateFilePath(template.getServiceImpl()), implFile);
//                    }
                }
                // MpController.java
                if (null != tableInfo.getControllerName() && null != pathInfo.get(ConstVal.CONTROLLER_PATH)) {
                    String controllerFile = String.format((pathInfo.get(ConstVal.CONTROLLER_PATH) + File.separator + tableInfo.getControllerName() + suffixJavaOrKt()), entityName);
                    writer(objectMap, templateFilePath(template.getController()), controllerFile);
//                    if (isCreate(FileType.CONTROLLER, controllerFile)) {
//                        writer(objectMap, templateFilePath(template.getController()), controllerFile);
//                    }
                }
                // Feign.java
                String feignFile = String.format((pathInfo.get(BocpConstVal.FEIGN_PATH) + File.separator + "%s" + ConstVal.JAVA_SUFFIX), entityName + "FeignApi");
                writer(objectMap, templateFilePath(template.getFeign()), feignFile);

            }

            // EntityMeta.java
            Map<String, Object> objectMap = getMetaObjectMap(tableInfoList, boGenInfoList);
            String entityMetaFile = String.format((pathInfo.get(ConstValEx.ENTITY_META_PATH) + File.separator + "%s" + suffixJavaOrKt()), "EntityMeta");
            writer(objectMap, templateFilePath(template.getEntityMeta(false)), entityMetaFile);

        } catch (Exception e) {
            logger.error("无法创建文件，请检查配置信息！", e);
        }
        return this;
    }

    /**
     * 渲染对象 MAP 信息
     *
     * @param tableInfo 表信息对象
     * @return ignore
     */
    public Map<String, Object> getObjectMap(TableInfo tableInfo, BoGenInfo boGenInfo, List<TableInfo> tableInfos) {
        Map<String, Object> objectMap = initTemplateParams();
        BocpConfigBuilder config = getBocpConfigBuilder();

        if(boGenInfo != null && "domain".equals(boGenInfo.getBoType())) {
            tableInfo.setConvert(true);
            tableInfo.setName(boGenInfo.getAlias());
        }

        //将参数放入map中用于模板解析
        objectMap.put("servicename", StringUtils.firstToLowerCase(tableInfo.getServiceName()));
        objectMap.put("entityname", StringUtils.firstToLowerCase(tableInfo.getEntityName()));
        objectMap.put("serviceimplname",Introspector.decapitalize(tableInfo.getServiceImplName()));

        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put("author", globalConfig.getAuthor());
        objectMap.put("idType", globalConfig.getIdType() == null ? null : globalConfig.getIdType().toString());
        objectMap.put("logicDeleteFieldName", config.getStrategyConfig().getLogicDeleteFieldName());
        objectMap.put("versionFieldName", config.getStrategyConfig().getVersionFieldName());
        objectMap.put("activeRecord", globalConfig.isActiveRecord());
        objectMap.put("kotlin", globalConfig.isKotlin());
        objectMap.put("swagger2", globalConfig.isSwagger2());
        objectMap.put("date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        objectMap.put("table", tableInfo);
        objectMap.put("enableCache", globalConfig.isEnableCache());
        objectMap.put("baseResultMap", globalConfig.isBaseResultMap());
        objectMap.put("baseColumnList", globalConfig.isBaseColumnList());

        objectMap.put("entity", tableInfo.getEntityName());
        objectMap.put("entitySerialVersionUID", config.getStrategyConfig().isEntitySerialVersionUID());
        objectMap.put("entityColumnConstant", config.getStrategyConfig().isEntityColumnConstant());
        objectMap.put("entityBuilderModel", config.getStrategyConfig().isEntityBuilderModel());
        objectMap.put("entityLombokModel", config.getStrategyConfig().isEntityLombokModel());
        objectMap.put("entityBooleanColumnRemoveIsPrefix", config.getStrategyConfig().isEntityBooleanColumnRemoveIsPrefix());
        objectMap.put("superEntityClass", getSuperClassName(config.getSuperEntityClass()));
        objectMap.put("superMapperClassPackage", config.getSuperMapperClass());
        objectMap.put("superMapperClass", getSuperClassName(config.getSuperMapperClass()));
        objectMap.put("superServiceClassPackage", config.getSuperServiceClass());
        objectMap.put("superServiceClass", getSuperClassName(config.getSuperServiceClass()));
        objectMap.put("superServiceImplClassPackage", config.getSuperServiceImplClass());
        objectMap.put("superServiceImplClass", getSuperClassName(config.getSuperServiceImplClass()));
        objectMap.put("superControllerClassPackage", config.getSuperControllerClass());
        objectMap.put("superControllerClass", getSuperClassName(config.getSuperControllerClass()));

        objectMap.put("formatUtils", GenFormatUtils.class);

        if(boGenInfo != null) {
            List<String> enumTypes = boGenInfo.getBoGenFieldList()
                    .stream().filter(field -> field.isEnum()).map(BoGenField::getFieldType)
                    .distinct().collect(Collectors.toList());
            if(CollectionUtils.isNotEmpty(enumTypes)) {
                objectMap.put("hasEnumType", true);
                objectMap.put("enumTypes", enumTypes);
            }

            if(!StringUtils.isEmpty(boGenInfo.getParentEntity())) {
                objectMap.put("hasParent", true);
                objectMap.put("parentEntity", boGenInfo.getParentEntity());
                if(tableInfos != null) {
                    tableInfos.stream().filter(table -> table.getEntityName().equals(boGenInfo.getParentEntity())).findAny()
                            .ifPresent(table -> {
                                List<String> childFields = tableInfo.getFields().stream().map(TableField::getPropertyName).collect(Collectors.toList());
                                List<TableField> fields = table.getFields()
                                        .stream()
                                        .filter(field -> !childFields.contains(field.getPropertyName())).collect(Collectors.toList());
                                objectMap.put("parentFields", fields);
                            });
                }
            }

            objectMap.put("entityId", boGenInfo.getId());
            //combo
            ComboInfo comboInfo = boGenInfo.getComboInfo();
            if(comboInfo != null) {
                objectMap.put("combo", comboInfo);
                objectMap.put("comboExist", comboInfo.getRelBos() != null && !comboInfo.getRelBos().isEmpty());
                objectMap.put("comboReverseExist", comboInfo.getRRelBos() != null && !comboInfo.getRRelBos().isEmpty());
                Map<String, String> entityFkMap = new HashMap<>();
                Optional.ofNullable(comboInfo.getRelBos()).ifPresent(relBos ->
                        relBos.stream().forEach(relBo -> {
                            if (relBo != null) {
                                entityFkMap.put(relBo.getRelHFieldCodes()[0], relBo.getRelFieldTypes()[0]);
                            }
                        })
                );
                objectMap.put("entityFks", entityFkMap);
            }
        }
        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }

    public Map<String, Object> getMetaObjectMap(List<TableInfo> tableInfoList, List<BoGenInfo> boGenInfoList) {
        Map<String, Object> objectMap = initTemplateParams();
        BocpConfigBuilder config = getBocpConfigBuilder();

        //将参数放入map中用于模板解析
        GlobalConfig globalConfig = config.getGlobalConfig();
        objectMap.put("author", globalConfig.getAuthor());
        objectMap.put("idType", globalConfig.getIdType() == null ? null : globalConfig.getIdType().toString());
        objectMap.put("versionFieldName", config.getStrategyConfig().getVersionFieldName());
        objectMap.put("kotlin", globalConfig.isKotlin());
        objectMap.put("date", new SimpleDateFormat("yyyy-MM-dd").format(new Date()));

        objectMap.put("tables", tableInfoList);
//        objectMap.put("bos", boGenInfoList);


        objectMap.put("tableCodeMap", boGenInfoList.stream().collect(Collectors.toMap(BoGenInfo::getName, BoGenInfo::getCode)));
        objectMap.put("tableIdMap", boGenInfoList.stream().collect(Collectors.toMap(BoGenInfo::getName, BoGenInfo::getId)));

        List<String> importPackages = tableInfoList.stream().map(tableInfo ->
                tableInfo.getImportPackages()
        ).flatMap(ips -> ips.stream()).distinct().collect(Collectors.toList());
        if(CollectionUtils.isNotEmpty(importPackages)) {
            objectMap.put("hasImportPackages", true);
            objectMap.put("imporPackages", importPackages);
        }

        List<String> enumTypes = boGenInfoList != null ? boGenInfoList.stream().map(boGenInfo ->
            boGenInfo.getBoGenFieldList()
                    .stream().filter(field -> field.isEnum()).map(BoGenField::getFieldType)
                    .distinct().collect(Collectors.toList())
        ).flatMap(ets -> ets.stream()).distinct().collect(Collectors.toList()) : new ArrayList<>();
        if(CollectionUtils.isNotEmpty(enumTypes)) {
            objectMap.put("hasEnumType", true);
            objectMap.put("enumTypes", enumTypes);
        }

        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }

}
