package com.xforceplus.ultraman.bocp.gen.engine;

import com.xforceplus.ultraman.bocp.gen.config.BocpConfigBuilder;
import com.xforceplus.ultraman.bocp.gen.config.BocpTemplateConfig;
import com.xforceplus.ultraman.bocp.gen.config.ConstValEx;
import com.xforceplus.ultraman.bocp.gen.po.DictGenInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DictVelocityTemplateEngine extends VelocityTemplateEngine {
    protected static final Logger logger = LoggerFactory.getLogger(DictVelocityTemplateEngine.class);

    /**
     * 输出 java xml 文件
     */
    @Override
    public DictVelocityTemplateEngine batchOutput() {
        try {
            List<DictGenInfo> dictGenInfos = getBocpConfigBuilder().getDictConfig().getDictGenInfos();
            for (DictGenInfo dictGenInfo : dictGenInfos) {
                Map<String, Object> objectMap = getObjectMap(dictGenInfo);
                Map<String, String> pathInfo = getBocpConfigBuilder().getPathInfo();
                BocpTemplateConfig template = getBocpConfigBuilder().getBocpTemplate();
                // *Dict.java
                if (null != dictGenInfo.getCode() && null != pathInfo.get(ConstValEx.ENUM_PATH)) {
                    String entityFile = String.format((pathInfo.get(ConstValEx.ENUM_PATH) + File.separator + "%s" + suffixJavaOrKt()), dictGenInfo.getCode());
                    writer(objectMap, templateFilePath(template.getEnum(getBocpConfigBuilder().getGlobalConfig().isKotlin())), entityFile);
                }
            }
        } catch (Exception e) {
            logger.error("无法创建文件，请检查配置信息！", e);
        }
        return this;
    }

    /**
     * 渲染对象 MAP 信息
     *
     * @param dictGenInfo 字典信息
     * @return ignore
     */
    public Map<String, Object> getObjectMap(DictGenInfo dictGenInfo) {
        Map<String, Object> objectMap = initTemplateParams();
        BocpConfigBuilder config = getBocpConfigBuilder();
        //将参数放入map中用于模板解析
        objectMap.put("dict", dictGenInfo);

        return Objects.isNull(config.getInjectionConfig()) ? objectMap : config.getInjectionConfig().prepareObjectMap(objectMap);
    }

}
