package com.xforceplus.ultraman.bocp.gen.engine;

import com.xforceplus.ultraman.bocp.gen.config.BocpConstVal;
import com.xforceplus.ultraman.bocp.gen.engine.*;

import java.util.HashMap;
import java.util.Map;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 11/6/2020 2:26 PM
 * @description:
 * @history:
 */
public class VelocityTemplateEngineFactory {
    private Map<String, VelocityTemplateEngine> templateEngineMap;

    public VelocityTemplateEngineFactory(){
        templateEngineMap = new HashMap<>();
    }

    public synchronized VelocityTemplateEngine getVelocityTemplateEngine(String engineType){
        VelocityTemplateEngine engine = templateEngineMap.get(engineType);
        if(engine == null) {
            switch (engineType) {
                case BocpConstVal.APPLICATIONENGINE:
                    engine = new ApplicationVelocityTemplateEngine();
                    break;
                case BocpConstVal.MODULEENGINE:
                    engine = new ModuleVelocityTemplateEngine();
                    break;
                case BocpConstVal.BOENGINE:
                    engine = new BoVelocityTemplateEngine();
                    break;
                case BocpConstVal.DTOENGINE:
                    engine = new DtoVelocityTemplateEngine();
                    break;
                case BocpConstVal.DICTENGINE:
                    engine = new DictVelocityTemplateEngine();
                    break;
                default:
            }
            if(engine != null) {
                templateEngineMap.put(engineType, engine);
            }
        }
        return engine;
    }
}
