export const BUTTON_LAYOUT = {
  TOP: 'top',
  BOTTOM: 'bottom',
  TABLE_OPERATION_COLUMN: 'table',
  enum: [
    {
      code: 'top',
      name: '顶栏',
    },
    {
      code: 'bottom',
      name: '底栏',
    },
    {
      code: 'table',
      name: '表格操作列',
    },
  ],
};

export const BUTTON_ACTION = {
  CREATE: 'create',
  UPDATE: 'update',
  DELETE: 'delete',
  IMPORT: 'import',
  EXPORT: 'export',
  PRINT: 'print',
  CUSTOM: 'custom',
};

export const INIT_BUTTONS = [
  {
    id: 0,
    name: '新增',
    layout: BUTTON_LAYOUT.TOP,
    enable: true,
    action: BUTTON_ACTION.CREATE,
  },
  {
    id: 1,
    name: '修改',
    layout: BUTTON_LAYOUT.TABLE_OPERATION_COLUMN,
    enable: true,
    action: BUTTON_ACTION.UPDATE,
  },
  {
    id: 2,
    name: '删除',
    layout: BUTTON_LAYOUT.TABLE_OPERATION_COLUMN,
    enable: true,
    action: BUTTON_ACTION.DELETE,
  },
  {
    id: 3,
    name: '删除',
    layout: BUTTON_LAYOUT.BOTTOM,
    enable: true,
    action: BUTTON_ACTION.DELETE,
  },
  {
    id: 4,
    name: '导入',
    layout: BUTTON_LAYOUT.TOP,
    enable: false,
    action: BUTTON_ACTION.IMPORT,
  },
  {
    id: 5,
    name: '导出',
    layout: BUTTON_LAYOUT.TOP,
    enable: false,
    action: BUTTON_ACTION.EXPORT,
  },
  {
    id: 6,
    name: '打印',
    layout: BUTTON_LAYOUT.TOP,
    enable: false,
    action: BUTTON_ACTION.PRINT,
  },
];

export const INIT_TABLE_SETTING = {
  selectable: true,
  selectAllEnable: false,
};

export const FIELD_TYPE = {
  STRING: {
    code: 'string',
    name: '字符型',
  },
  TEXT: {
    code: 'text',
    name: '长文本型',
  },
  NUMBER: {
    code: 'number',
    name: '数字型',
  },
  BOOLEAN: {
    code: 'boolean',
    name: '布尔型',
  },
  TIMESTAMP: {
    code: 'timestamp',
    name: '时间戳',
  },
  ENUM: {
    code: 'enum',
    name: '枚举型',
  },
  RELATIONSHIP: {
    code: 'relationship',
    name: '关系型',
  },
  string: '字符型',
  text: '长文本型',
  number: '数字型',
  boolean: '布尔型',
  timestamp: '时间戳',
  enum: '枚举型',
  relationship: '关系型',
};

export const SEARCH_OPERATION = {
  EQUAL: {
    code: 'eq',
    name: '等于',
  },
  LIKE: {
    code: 'like',
    name: '模糊匹配',
  },
  IN: {
    code: 'in',
    name: '多选',
  },
  RANGE: {
    code: 'gteq&lteq',
    name: '区间查询',
  },
  LARGER_THEN: {
    code: 'gt',
    name: '大于',
  },
  LITTLE_THEN: {
    code: 'lt',
    name: '小于',
  },
};

export const UI_WIDGET = {
  INPUT: {
    code: 'input',
    name: '文本输入框',
  },
  TEXTAREA: {
    code: 'textarea',
    name: '长文本输入框',
  },
  RICH_TEXT_EDITOR: {
    code: 'richTextEditor',
    name: '富文本输入框',
  },
  INPUT_NUMBER: {
    code: 'inputNumber',
    name: '数字输入框',
  },
  INPUT_NUMBER_RANGE: {
    code: 'inputNumberRange',
    name: '数字范围输入框',
  },
  TIME_PICKER: {
    code: 'timePicker',
    name: '时间选择器',
  },
  DATE_PICKER: {
    code: 'datePicker',
    name: '日期选择器',
  },
  MONTH_PICKER: {
    code: 'monthPicker',
    name: '月份选择器',
  },
  DATE_RANGE_PCIKER: {
    code: 'dateRangePicker',
    name: '日期范围选择器',
  },
  SELECT: {
    code: 'select',
    name: '选择器',
  },
  RADIO: {
    code: 'radio',
    name: '单选项',
  },
  SWITCH: {
    code: 'switch',
    name: '开关',
  },
  AUTO_COMPLETE: {
    code: 'autoComplete',
    name: '自动补全输入框',
  },
  CASCADER: {
    code: 'cascader',
    name: '级联选择器',
  },
  CUSTOM: {
    code: 'custorm',
    name: '自定义组件',
  },
};

export const FIELD_DISCRIBE_TYPE = {
  NONE: '0',
  PRIMARY: '1',
  SECONDARY: '2',
};

export const DEFAULT_EDIT_UI_WIDGET = {
  [FIELD_TYPE.STRING.code]: UI_WIDGET.INPUT.code,
  [FIELD_TYPE.TEXT.code]: UI_WIDGET.TEXTAREA.code,
  [FIELD_TYPE.NUMBER.code]: UI_WIDGET.INPUT_NUMBER.code,
  [FIELD_TYPE.BOOLEAN.code]: UI_WIDGET.SWITCH.code,
  [FIELD_TYPE.TIMESTAMP.code]: UI_WIDGET.DATE_PICKER.code,
  [FIELD_TYPE.ENUM.code]: UI_WIDGET.SELECT.code,
  [FIELD_TYPE.RELATIONSHIP.code]: UI_WIDGET.SELECT.code,
};

export const DEFAULT_SEARCH_OPERATION_TYPE = {
  [FIELD_TYPE.STRING.code]: SEARCH_OPERATION.EQUAL.code,
  [FIELD_TYPE.TEXT.code]: SEARCH_OPERATION.EQUAL.code,
  [FIELD_TYPE.NUMBER.code]: SEARCH_OPERATION.RANGE.code,
  [FIELD_TYPE.TIMESTAMP.code]: SEARCH_OPERATION.RANGE.code,
  [FIELD_TYPE.BOOLEAN.code]: SEARCH_OPERATION.EQUAL.code,
  [FIELD_TYPE.ENUM.code]: SEARCH_OPERATION.EQUAL.code,
  [FIELD_TYPE.RELATIONSHIP.code]: SEARCH_OPERATION.EQUAL.code,
};

export const DEFAULT_SEARCH_UI_WIDGET = {
  [FIELD_TYPE.STRING.code]: UI_WIDGET.INPUT.code,
  [FIELD_TYPE.TEXT.code]: UI_WIDGET.INPUT.code,
  [FIELD_TYPE.NUMBER.code]: UI_WIDGET.INPUT_NUMBER_RANGE.code,
  [FIELD_TYPE.TIMESTAMP.code]: UI_WIDGET.DATE_RANGE_PCIKER.code,
  [FIELD_TYPE.BOOLEAN.code]: UI_WIDGET.RADIO.code,
  [FIELD_TYPE.ENUM.code]: UI_WIDGET.SELECT.code,
  [FIELD_TYPE.RELATIONSHIP.code]: UI_WIDGET.SELECT.code,
};

export const DIFF_STATUS = {
  CHANGED: 1,
  NEW: 2,
  DELETED: 3,
};

export const DEFAULT_VALUE = {
  TIMESTAMP: {
    CURRENT: 1,
  },
};
