package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 应用模块信息feign客户端
 *
 * @author wangzheng
 * @date 2020-02-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.AppModule;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface AppModuleFeignApi {

  /**
   * 通过id查询应用模块信息
   * @param  id
   * @return R
   */
  @GetMapping("/appModule/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增应用模块信息
   * @param appModule 应用模块信息
   * @return R
   */
  @PostMapping("/appModule/add")
  public R save(@RequestBody AppModule appModule);

  /**
   * 修改应用模块信息
   * @param appModule 应用模块信息
   * @return R
   */
  @PostMapping("/appModule/update")
  public R updateById(@RequestBody AppModule appModule);

  /**
   * 通过id删除应用模块信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/appModule/del/{id}" )
  public R removeById(@PathVariable Long id);

}