package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 业务对象字段信息feign客户端
 *
 * @author wangzheng
 * @date 2020-02-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.BoField;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface BoFieldFeignApi {

  /**
   * 通过id查询业务对象字段信息
   * @param  id
   * @return R
   */
  @GetMapping("/boField/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增业务对象字段信息
   * @param boField 业务对象字段信息
   * @return R
   */
  @PostMapping("/boField/add")
  public R save(@RequestBody BoField boField);

  /**
   * 修改业务对象字段信息
   * @param boField 业务对象字段信息
   * @return R
   */
  @PostMapping("/boField/update")
  public R updateById(@RequestBody BoField boField);

  /**
   * 通过id删除业务对象字段信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/boField/del/{id}" )
  public R removeById(@PathVariable Long id);

}