package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 字典库信息feign客户端
 *
 * @author wangzheng
 * @date 2020-02-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.Dict;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface DictFeignApi {

  /**
   * 通过id查询字典库信息
   * @param  id
   * @return R
   */
  @GetMapping("/dict/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增字典库信息
   * @param dict 字典库信息
   * @return R
   */
  @PostMapping("/dict/add")
  public R save(@RequestBody Dict dict);

  /**
   * 修改字典库信息
   * @param dict 字典库信息
   * @return R
   */
  @PostMapping("/dict/update")
  public R updateById(@RequestBody Dict dict);

  /**
   * 通过id删除字典库信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/dict/del/{id}" )
  public R removeById(@PathVariable Long id);

}