package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 领域信息feign客户端
 *
 * @author wangzheng
 * @date 2020-02-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.Domain;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface DomainFeignApi {

  /**
   * 通过id查询领域信息
   * @param  id
   * @return R
   */
  @GetMapping("/domain/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增领域信息
   * @param domain 领域信息
   * @return R
   */
  @PostMapping("/domain/add")
  public R save(@RequestBody Domain domain);

  /**
   * 修改领域信息
   * @param domain 领域信息
   * @return R
   */
  @PostMapping("/domain/update")
  public R updateById(@RequestBody Domain domain);

  /**
   * 通过id删除领域信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/domain/del/{id}" )
  public R removeById(@PathVariable Long id);

}