package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 字段库信息feign客户端
 *
 * @author wangzheng
 * @date 2020-02-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.FieldLib;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface FieldLibFeignApi {

  /**
   * 通过id查询字段库信息
   * @param  id
   * @return R
   */
  @GetMapping("/fieldLib/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增字段库信息
   * @param fieldLib 字段库信息
   * @return R
   */
  @PostMapping("/fieldLib/add")
  public R save(@RequestBody FieldLib fieldLib);

  /**
   * 修改字段库信息
   * @param fieldLib 字段库信息
   * @return R
   */
  @PostMapping("/fieldLib/update")
  public R updateById(@RequestBody FieldLib fieldLib);

  /**
   * 通过id删除字段库信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/fieldLib/del/{id}" )
  public R removeById(@PathVariable Long id);

}