package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 模块业务对象信息feign客户端
 *
 * @author wangzheng
 * @date 2020-02-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.ModuleBo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface ModuleBoFeignApi {

  /**
   * 通过id查询模块业务对象信息
   * @param  id
   * @return R
   */
  @GetMapping("/moduleBo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增模块业务对象信息
   * @param moduleBo 模块业务对象信息
   * @return R
   */
  @PostMapping("/moduleBo/add")
  public R save(@RequestBody ModuleBo moduleBo);

  /**
   * 修改模块业务对象信息
   * @param moduleBo 模块业务对象信息
   * @return R
   */
  @PostMapping("/moduleBo/update")
  public R updateById(@RequestBody ModuleBo moduleBo);

  /**
   * 通过id删除模块业务对象信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/moduleBo/del/{id}" )
  public R removeById(@PathVariable Long id);

}