package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 模块领域信息feign客户端
 *
 * @author wangzheng
 * @date 2020-02-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.ModuleDomain;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface ModuleDomainFeignApi {

  /**
   * 通过id查询模块领域信息
   * @param  id
   * @return R
   */
  @GetMapping("/moduleDomain/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增模块领域信息
   * @param moduleDomain 模块领域信息
   * @return R
   */
  @PostMapping("/moduleDomain/add")
  public R save(@RequestBody ModuleDomain moduleDomain);

  /**
   * 修改模块领域信息
   * @param moduleDomain 模块领域信息
   * @return R
   */
  @PostMapping("/moduleDomain/update")
  public R updateById(@RequestBody ModuleDomain moduleDomain);

  /**
   * 通过id删除模块领域信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/moduleDomain/del/{id}" )
  public R removeById(@PathVariable Long id);

}