package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 应用环境表feign客户端
 *
 * @author wangzheng
 * @date 2020-02-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.ModuleEnv;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface ModuleEnvFeignApi {

  /**
   * 通过id查询应用环境表
   * @param  id
   * @return R
   */
  @GetMapping("/moduleEnv/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增应用环境表
   * @param moduleEnv 应用环境表
   * @return R
   */
  @PostMapping("/moduleEnv/add")
  public R save(@RequestBody ModuleEnv moduleEnv);

  /**
   * 修改应用环境表
   * @param moduleEnv 应用环境表
   * @return R
   */
  @PostMapping("/moduleEnv/update")
  public R updateById(@RequestBody ModuleEnv moduleEnv);

  /**
   * 通过id删除应用环境表
   * @param  id
   * @return R
   */
  @DeleteMapping("/moduleEnv/del/{id}" )
  public R removeById(@PathVariable Long id);

}