package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 模块基础信息feign客户端
 *
 * @author wangzheng
 * @date 2020-02-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.Module;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface ModuleFeignApi {

  /**
   * 通过id查询模块基础信息
   * @param  id
   * @return R
   */
  @GetMapping("/module/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增模块基础信息
   * @param module 模块基础信息
   * @return R
   */
  @PostMapping("/module/add")
  public R save(@RequestBody Module module);

  /**
   * 修改模块基础信息
   * @param module 模块基础信息
   * @return R
   */
  @PostMapping("/module/update")
  public R updateById(@RequestBody Module module);

  /**
   * 通过id删除模块基础信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/module/del/{id}" )
  public R removeById(@PathVariable Long id);

}