package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * paas平台client信息feign客户端
 *
 * @author wangzheng
 * @date 2020-02-12
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.PaasClient;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface PaasClientFeignApi {

  /**
   * 通过id查询paas平台client信息
   * @param  id
   * @return R
   */
  @GetMapping("/paasClient/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增paas平台client信息
   * @param paasClient paas平台client信息
   * @return R
   */
  @PostMapping("/paasClient/add")
  public R save(@RequestBody PaasClient paasClient);

  /**
   * 修改paas平台client信息
   * @param paasClient paas平台client信息
   * @return R
   */
  @PostMapping("/paasClient/update")
  public R updateById(@RequestBody PaasClient paasClient);

  /**
   * 通过id删除paas平台client信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/paasClient/del/{id}" )
  public R removeById(@PathVariable Long id);

}