package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 业务对象API信息feign客户端
 *
 * @author wangzheng
 * @date 2020-09-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.BoApi;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface BoApiFeignApi {

  /**
   * 通过id查询业务对象API信息
   * @param  id
   * @return R
   */
  @GetMapping("/boApi/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增业务对象API信息
   * @param boApi 业务对象API信息
   * @return R
   */
  @PostMapping("/boApi/add")
  public R save(@RequestBody BoApi boApi);

  /**
   * 修改业务对象API信息
   * @param boApi 业务对象API信息
   * @return R
   */
  @PostMapping("/boApi/update")
  public R updateById(@RequestBody BoApi boApi);

  /**
   * 通过id删除业务对象API信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/boApi/del/{id}" )
  public R removeById(@PathVariable Long id);

}