package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 业务对象基础信息feign客户端
 *
 * @author wangzheng
 * @date 2020-09-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.Bo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface BoFeignApi {

  /**
   * 通过id查询业务对象基础信息
   * @param  id
   * @return R
   */
  @GetMapping("/bo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增业务对象基础信息
   * @param bo 业务对象基础信息
   * @return R
   */
  @PostMapping("/bo/add")
  public R save(@RequestBody Bo bo);

  /**
   * 修改业务对象基础信息
   * @param bo 业务对象基础信息
   * @return R
   */
  @PostMapping("/bo/update")
  public R updateById(@RequestBody Bo bo);

  /**
   * 通过id删除业务对象基础信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/bo/del/{id}" )
  public R removeById(@PathVariable Long id);

}