package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 奥特曼操作履历表feign客户端
 *
 * @author wangzheng
 * @date 2020-09-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.BoOperatResume;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface BoOperatResumeFeignApi {

  /**
   * 通过id查询奥特曼操作履历表
   * @param  id
   * @return R
   */
  @GetMapping("/boOperatResume/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增奥特曼操作履历表
   * @param boOperatResume 奥特曼操作履历表
   * @return R
   */
  @PostMapping("/boOperatResume/add")
  public R save(@RequestBody BoOperatResume boOperatResume);

  /**
   * 修改奥特曼操作履历表
   * @param boOperatResume 奥特曼操作履历表
   * @return R
   */
  @PostMapping("/boOperatResume/update")
  public R updateById(@RequestBody BoOperatResume boOperatResume);

  /**
   * 通过id删除奥特曼操作履历表
   * @param  id
   * @return R
   */
  @DeleteMapping("/boOperatResume/del/{id}" )
  public R removeById(@PathVariable Long id);

}