package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 事件信息feign客户端
 *
 * @author wangzheng
 * @date 2020-09-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.Event;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface EventFeignApi {

  /**
   * 通过id查询事件信息
   * @param  id
   * @return R
   */
  @GetMapping("/event/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增事件信息
   * @param event 事件信息
   * @return R
   */
  @PostMapping("/event/add")
  public R save(@RequestBody Event event);

  /**
   * 修改事件信息
   * @param event 事件信息
   * @return R
   */
  @PostMapping("/event/update")
  public R updateById(@RequestBody Event event);

  /**
   * 通过id删除事件信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/event/del/{id}" )
  public R removeById(@PathVariable Long id);

}