package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 字段属性信息feign客户端
 *
 * @author wangzheng
 * @date 2020-09-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.FieldAttribute;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface FieldAttributeFeignApi {

  /**
   * 通过id查询字段属性信息
   * @param  id
   * @return R
   */
  @GetMapping("/fieldAttribute/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增字段属性信息
   * @param fieldAttribute 字段属性信息
   * @return R
   */
  @PostMapping("/fieldAttribute/add")
  public R save(@RequestBody FieldAttribute fieldAttribute);

  /**
   * 修改字段属性信息
   * @param fieldAttribute 字段属性信息
   * @return R
   */
  @PostMapping("/fieldAttribute/update")
  public R updateById(@RequestBody FieldAttribute fieldAttribute);

  /**
   * 通过id删除字段属性信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/fieldAttribute/del/{id}" )
  public R removeById(@PathVariable Long id);

}