package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 字段类型feign客户端
 *
 * @author wangzheng
 * @date 2020-09-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.FieldType;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface FieldTypeFeignApi {

  /**
   * 通过id查询字段类型
   * @param  id
   * @return R
   */
  @GetMapping("/fieldType/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增字段类型
   * @param fieldType 字段类型
   * @return R
   */
  @PostMapping("/fieldType/add")
  public R save(@RequestBody FieldType fieldType);

  /**
   * 修改字段类型
   * @param fieldType 字段类型
   * @return R
   */
  @PostMapping("/fieldType/update")
  public R updateById(@RequestBody FieldType fieldType);

  /**
   * 通过id删除字段类型
   * @param  id
   * @return R
   */
  @DeleteMapping("/fieldType/del/{id}" )
  public R removeById(@PathVariable Long id);

}