package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 项目基础信息feign客户端
 *
 * @author wangzheng
 * @date 2020-09-23
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.Project;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface ProjectFeignApi {

  /**
   * 通过id查询项目基础信息
   * @param  id
   * @return R
   */
  @GetMapping("/project/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增项目基础信息
   * @param project 项目基础信息
   * @return R
   */
  @PostMapping("/project/add")
  public R save(@RequestBody Project project);

  /**
   * 修改项目基础信息
   * @param project 项目基础信息
   * @return R
   */
  @PostMapping("/project/update")
  public R updateById(@RequestBody Project project);

  /**
   * 通过id删除项目基础信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/project/del/{id}" )
  public R removeById(@PathVariable Long id);

}