package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 应用部署日志表feign客户端
 *
 * @author wangzheng
 * @date 2021-11-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.AppVersion;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface AppVersionFeignApi {

  /**
   * 通过id查询应用部署日志表
   * @param  id
   * @return R
   */
  @GetMapping("/appVersion/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增应用部署日志表
   * @param appVersion 应用部署日志表
   * @return R
   */
  @PostMapping("/appVersion/add")
  public R save(@RequestBody AppVersion appVersion);

  /**
   * 修改应用部署日志表
   * @param appVersion 应用部署日志表
   * @return R
   */
  @PostMapping("/appVersion/update")
  public R updateById(@RequestBody AppVersion appVersion);

  /**
   * 通过id删除应用部署日志表
   * @param  id
   * @return R
   */
  @DeleteMapping("/appVersion/del/{id}" )
  public R removeById(@PathVariable Long id);

}
