package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * feign客户端
 *
 * @author wangzheng
 * @date 2021-11-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.BoApiDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface BoApiDetailFeignApi {

  /**
   * 通过id查询
   * @param  id
   * @return R
   */
  @GetMapping("/boApiDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增
   * @param boApiDetail 
   * @return R
   */
  @PostMapping("/boApiDetail/add")
  public R save(@RequestBody BoApiDetail boApiDetail);

  /**
   * 修改
   * @param boApiDetail 
   * @return R
   */
  @PostMapping("/boApiDetail/update")
  public R updateById(@RequestBody BoApiDetail boApiDetail);

  /**
   * 通过id删除
   * @param  id
   * @return R
   */
  @DeleteMapping("/boApiDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}
