package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * feign客户端
 *
 * @author wangzheng
 * @date 2021-11-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.BoDomain;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface BoDomainFeignApi {

  /**
   * 通过id查询
   * @param  id
   * @return R
   */
  @GetMapping("/boDomain/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增
   * @param boDomain 
   * @return R
   */
  @PostMapping("/boDomain/add")
  public R save(@RequestBody BoDomain boDomain);

  /**
   * 修改
   * @param boDomain 
   * @return R
   */
  @PostMapping("/boDomain/update")
  public R updateById(@RequestBody BoDomain boDomain);

  /**
   * 通过id删除
   * @param  id
   * @return R
   */
  @DeleteMapping("/boDomain/del/{id}" )
  public R removeById(@PathVariable Long id);

}
