package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 领域字段属性表feign客户端
 *
 * @author wangzheng
 * @date 2021-11-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.BoFieldDomainAttribute;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface BoFieldDomainAttributeFeignApi {

  /**
   * 通过id查询领域字段属性表
   * @param  id
   * @return R
   */
  @GetMapping("/boFieldDomainAttribute/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增领域字段属性表
   * @param boFieldDomainAttribute 领域字段属性表
   * @return R
   */
  @PostMapping("/boFieldDomainAttribute/add")
  public R save(@RequestBody BoFieldDomainAttribute boFieldDomainAttribute);

  /**
   * 修改领域字段属性表
   * @param boFieldDomainAttribute 领域字段属性表
   * @return R
   */
  @PostMapping("/boFieldDomainAttribute/update")
  public R updateById(@RequestBody BoFieldDomainAttribute boFieldDomainAttribute);

  /**
   * 通过id删除领域字段属性表
   * @param  id
   * @return R
   */
  @DeleteMapping("/boFieldDomainAttribute/del/{id}" )
  public R removeById(@PathVariable Long id);

}
