package com.xforceplus.ultraman.bocp.metadata.controller;


/**
 * 公式库feign客户端
 *
 * @author wangzheng
 * @date 2021-11-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.bocp.metadata.entity.FormulaLib;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "ultraman-bocp-metadata")
public interface FormulaLibFeignApi {

  /**
   * 通过id查询公式库
   * @param  id
   * @return R
   */
  @GetMapping("/formulaLib/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增公式库
   * @param formulaLib 公式库
   * @return R
   */
  @PostMapping("/formulaLib/add")
  public R save(@RequestBody FormulaLib formulaLib);

  /**
   * 修改公式库
   * @param formulaLib 公式库
   * @return R
   */
  @PostMapping("/formulaLib/update")
  public R updateById(@RequestBody FormulaLib formulaLib);

  /**
   * 通过id删除公式库
   * @param  id
   * @return R
   */
  @DeleteMapping("/formulaLib/del/{id}" )
  public R removeById(@PathVariable Long id);

}
